//
// Bundle.h
//

#pragma once

#include <Raym/Object.h>
#include <Raym/Dictionary.h>

namespace Raym
{

class Bundle : public Object
{
private:
    String *          _path;
    Dictionary *      _localizedStrings;

protected:
    Bundle();
    ~Bundle();

public:
    static Bundle *alloc();
    static Bundle *mainBundle();
    Bundle *initWithPath(String *path);
    Bundle *retain();
    Bundle *autorelease();

    String *localizedStringForKey(const char *key, const char *value, const char *tableName);

    virtual const char *className();
};

} // Raym

