//
// Bundle.cpp
//

#define DBG_LEVEL 0
#include <Raym/Log.h>
#include <Raym/Bundle.h>

namespace Raym
{

DEFINE_STATIC_MUTEX(mutex_);
static Bundle *mainBundle_ = NULL;

Bundle::Bundle()
{
    DebugLog2("Bundle::Bundle()");

    _path = NULL;
    _localizedStrings = NULL;
}

Bundle::~Bundle()
{
    RELEASE(_path);
    if (_path != NULL)
    {
        _path->release();
    }
    RELEASE(_localizedStrings);
    if (_localizedStrings != NULL)
    {
        _localizedStrings->release();
    }

    DebugLog2("Bundle::~Bundle()");
}

Bundle *Bundle::alloc()
{
    DebugLog2("Bundle::alloc()");
    return new Bundle();
}

Bundle *Bundle::mainBundle()
{
    DebugLog2("Bundle::mainBundle()");

    mutex_.lock();

    if (mainBundle_ == NULL)
    {
        String *path = NULL;
#ifdef _WIN32
        static char execute_path_[MAX_PATH + 1];
        memset(execute_path_, 0x00, sizeof(execute_path_));

        TCHAR strbuf[MAX_PATH + 1];
        if (GetModuleFileName(NULL, strbuf, MAX_PATH) != 0)
        {
            errno_t e;
            size_t returnValue;
            e = wcstombs_s(&returnValue, execute_path_, sizeof(execute_path_), strbuf, _TRUNCATE);
            if (e == 0)
            {
                char drive[_MAX_DRIVE];
                char dir[_MAX_DIR];

                if (_splitpath_s(execute_path_, drive, sizeof(drive), dir, sizeof(dir), NULL, 0, NULL, 0) == 0)
                {
                    path = String::stringWithFormat("%s%s", drive, dir);
                }
            }
        }
#else
        // other platform
#endif
        if (path != NULL)
        {
            mainBundle_ = Bundle::alloc()->initWithPath(path);
            ((Object *)mainBundle_)->autorelease(true);
        }
        else
        {
            DebugLog0("Bundle::mainBundle() abort.");
            abort();
        }
    }
    mutex_.unlock();

    return mainBundle_;
}

Bundle *Bundle::initWithPath(String *path)
{
    DebugLog2("Bundle::initWithPath(path)");
    DebugLog3("path: %s", path->cString());

    RELEASE(_path);
    if (_path != NULL)
    {
        _path->release();
        _path = NULL;
    }
    _path = path->retain();

    if (_localizedStrings != NULL)
    {
        _localizedStrings->release();
        _localizedStrings = NULL;
    }

    _localizedStrings = Dictionary::alloc()->initWithContentsOfFile(_path->stringByAppendingPathComponent("Localizable.strings"));
    if (_localizedStrings == NULL)
    {
        DebugLog3("_localizedStrings is NULL");
    }

    return this;
}

String *Bundle::localizedStringForKey(const char *key, const char *value, const char *tableName)
{
    DebugLog2("Bundle::localizedStringForKey(key,value,tableName)");

    if ((key == NULL) && (value == NULL))
    {
        return NULL;
    }

    Dictionary *table = NULL;
    if (tableName != NULL)
    {

    }
    else
    {
        table = _localizedStrings;
    }
    if (table != NULL)
    {
        if (table->stringForKey(key) != NULL)
        {
            return table->stringForKey(key);
        }
    }
    if (value != NULL)
    {
        return String::stringWithUTF8String(value);
    }
    return String::stringWithUTF8String(key);
}

const char *Bundle::className()
{
    return "Bundle";
}

} // Raym
