//
// Array.h
//

#ifndef __RAYM_ARRAY_H__
#define __RAYM_ARRAY_H__

#include <vector>

#include <Raym/Object.h>

namespace Raym
{

class Array : public Object
{
protected:
    Array();
    ~Array();

    std::vector<Object *> _array;

public:
    //
    static Array *arrayWithCapacity(UInteger numItems);
    static Array *alloc();
    Array *initWithCapacity(UInteger numItems);
    Array *retain();
    Array *autorelease();

    UInteger count();
    void addObject(Object *object);
    void addObjectsFromArray(Array *array);
    Object *objectAtIndex(UInteger index);

    void insertObject(Object *object, UInteger index);

    void removeObject(Object *object);
    void removeObjectAtIndex(UInteger index);

    void removeAllObjects();

    Array *sortedArrayUsingFunction(Integer (*function)(Object *, Object *, void *), void *context);

    virtual const char *className();
};

} // Raym

#endif // __RAYM_ARRAY_H__
