//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "TWRequest.h"
#import "PUCommon.h"
#import "NSXMLElement-ex.h"

@implementation TWRequest

-(id) init
{
	if (self = [super initWithURL:[NSURL URLWithString:[NSString stringWithFormat:@"%@%@", TWITPIC_API_PATH, @"uploadAndPost"]] withMethod:@"POST"]) {
	}
	return self;
}

-(void) start
{
	NSURL* fileUrl = [self valueForKeyPath:@"param.fileUrl"];
	NSString* comment = [self valueForKeyPath:@"param.comment"];	
	NSString* contentType = [self valueForKeyPath:@"param.contentType"];	
	NSString* account = [self valueForKeyPath:@"serviceParam.account"];
	NSString* password = [self valueForKeyPath:@"serviceParam.password"];

	if (!(fileUrl && [fileUrl isFileURL])) {
		return;
	}
	if (IS_NULL_STR(account) || IS_NULL_STR(password)) {
		return;
	}
	
	[m_postData setObject:[NSDictionary dictionaryWithObjectsAndKeys:
						   fileUrl,		KEY_URL,
						   contentType,	KEY_TYPE,
						   nil]
				   forKey:@"media"];
	[m_postData setObject:account forKey:@"username"];
	[m_postData setObject:password forKey:@"password"];
	
	NSString* msg = nil;
	if (!IS_NULL_STR(_message)) {
		msg = _message;
	} else {
		if (!IS_NULL_STR(comment)) {
			msg = comment;
		}
	}
	if (IS_NULL_STR(msg)) {
		msg = @"#iPhotoUploader";
	} else {
		msg = [NSString stringWithFormat:@"%@ #iPhotoUploader", msg];
	}
	if (!IS_NULL_STR(msg)) {
		[m_postData setObject:msg forKey:@"message"];
	}
		
	[super start];
}

-(id) responseData:(NSError**)error
{
	NSXMLDocument* xml = [super responseData:error];
	if (!xml || *error) {
		if (!*error) {
			*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];
		}
		return xml;
	}
	
	if ([xml isKindOfClass:[NSXMLDocument class]]) {
		NSError* err = nil;
		NSXMLElement* element = [[xml rootElement] nodeForXPath:@"/rsp/mediaurl" error:&err];
		if (!err) {
			*error = nil;
			return [element stringValue];
		} else {
			*error = err;
		}
	} else {
		*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];				
	}
	return nil;
}

@end
