//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "PhotoZou_PhotoAdd.h"
#import "NSXMLElement-ex.h"
#import "PZPhoto.h"
#import "PUCommon.h"

@implementation PhotoZou_PhotoAdd

-(id) init
{
	if (self = [super initWithURL:[NSURL URLWithString:PHOTOZOU_REST_PATH(@"photo_add")] withMethod:@"POST"]) {
	}
	return self;
}

-(void) start
{
	NSURL* fileUrl			= [self valueForKeyPath:@"param.fileUrl"];
	NSString* title			= [self valueForKeyPath:@"param.title"];
	NSString* contentType	= [self valueForKeyPath:@"param.contentType"];	
	NSString* comment		= [self valueForKeyPath:@"param.comment"];	
	NSArray* keyword		= [self valueForKeyPath:@"param.keyword"];		
	
	if (!(fileUrl && [fileUrl isFileURL] && contentType && _albumId != 0)) {
		return;
	}

	[m_postData setObject:[NSDictionary dictionaryWithObjectsAndKeys:
					   fileUrl,		KEY_URL,
					   contentType,	KEY_TYPE,
					   nil]
			   forKey:@"photo"];
	[m_postData setObject:[NSString stringWithFormat:@"%d", _albumId] forKey:@"album_id"];
	
	if (!IS_NULL_STR(title)) {
		[m_postData setObject:title forKey:@"photo_title"];
	}
	if (keyword && [keyword count] > 0) {
		[m_postData setObject:[keyword componentsJoinedByString:@" "] forKey:@"tag"];
	}
	if (!IS_NULL_STR(comment)) {
		[m_postData setObject:comment forKey:@"comment"];
	}
	
	[super start];
}

-(id) responseData:(NSError**)error
{
	NSXMLDocument* xml = [super responseData:error];
	if (!xml || *error) {
		if (!*error) {
			*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];
		}
		return xml;
	}
	
	if ([xml isKindOfClass:[NSXMLDocument class]]) {
		NSError* err = nil;
		NSEnumerator* enume = [[[[xml rootElement] nodeForXPath:@"/rsp" error:&err] children] objectEnumerator];
		if (!err) {
			NSXMLElement* child;
			PZPhoto* photo = [[PZPhoto alloc] init];
			while (child = [enume nextObject]) {
				[photo setValue:[child objectValue] forKey:[child name]];
			}
			*error = nil;
			return [photo autorelease];
		} else {
			*error = err;
		}
	} else {
		*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];				
	}
	return nil;
}

@end
