//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "Mixi_Photo.h"
#import "MXAlbum.h"
#import "MXPhoto.h"
#import "NSXMLElement-ex.h"
#import "PUCommon.h"

@implementation Mixi_Photo

-(id) initWithAlbum:(MXAlbum*)album
{
	if (!(album && [album valueForKey:@"href"])) {
		return nil;
	}
	if (self = [super initWithURL:[NSURL URLWithString:[album valueForKey:@"href"]] withMethod:@"POST"]) {
	}
	return self;
}

-(void) start
{
	NSURL* fileUrl			= [self valueForKeyPath:@"param.fileUrl"];
	NSString* contentType	= [self valueForKeyPath:@"param.contentType"];	
	
	if (!(fileUrl && [fileUrl isFileURL] && contentType)) {
		return;
	}

	NSData* data = [NSData dataWithContentsOfURL:fileUrl];
	if (data) {
		CFHTTPMessageSetHeaderFieldValue(m_message, CFSTR("Content-type"), (CFStringRef)contentType);
		CFHTTPMessageSetBody(m_message, (CFDataRef)data);
		CFHTTPMessageSetHeaderFieldValue(m_message, CFSTR("Content-Length"), (CFStringRef)[NSString stringWithFormat: @"%d", [data length]]);

		[super start];
	}
}

-(id) responseData:(NSError**)error
{
	NSXMLDocument* xml = [super responseData:error];
	if (!xml || *error) {
		if (!*error) {
			*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];
		}
		return xml;
	}
	if ([xml isKindOfClass:[NSXMLDocument class]]) {
		NSError* err = nil;
		NSXMLElement* node = [[xml rootElement] nodeForXPath:@"/entry/link" error:&err];
		if (!err) {
			if (node) {
				MXPhoto* photo = [[MXPhoto alloc] init];
				[photo setValue:[node attributeValueForName:@"href"] forKey:@"url"];
				*error = nil;
				return [photo autorelease];
			} else {
				*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];				
			}
		} else {
			*error = err;
		}
	} else {
		*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];
	}
	return nil;
}


@end
