//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "PUServiceParam.h"
#import "PUUserDefaults.h"
#import "KeychainAccessor.h"

#define OBSERVE_KEY_LIST	@"title", @"keyword", @"comment", @"format", @"size"
#define SAVE_KEY_LIST		@"account", OBSERVE_KEY_LIST
#define OBSERVE_KEY_ARRAY	[NSArray arrayWithObjects:OBSERVE_KEY_LIST, nil]
#define	SAVE_KEY_ARRAY		[NSArray arrayWithObjects:SAVE_KEY_LIST, nil]

@interface PUServiceParam (Private)

-(void) save;
-(void) load;

@end

@implementation PUServiceParam

-(void) setAccount:(id)value
{
	BOOL changed = YES;
	if (_account) {
		if ([value isEqualTo:_account]) {
			changed = NO;
		}
		[_account release];
	}
	_account = [value copy];
	if (IS_NULL_STR(_password) && !IS_NULL_STR(_account) && _keychainURL) {
		NSString* password = [KeychainAccessor getInternetPassword:_account url:_keychainURL];
		[self setValue:password forKey:@"password"];
	}
	
	if (changed && _keychainURL) {
		[KeychainAccessor changeInternetPassword:_password account:_account url:_keychainURL];
		[self save];
	}
}

-(void) setPassword:(id)value
{
	BOOL changed = YES;
	if (_password) {
		if ([value isEqualTo:_password]) {
			changed = NO;
		}
		[_password release];
	}
	_password = [value copy];
	
	if (changed && _keychainURL) {
		[KeychainAccessor changeInternetPassword:_password account:_account url:_keychainURL];
	}
}

-(void) setSaveKey:(id)value
{
	BOOL first = NO;
	if (_saveKey) {
		[_saveKey release];
	} else {
		first = YES;
		NSEnumerator* enume = [OBSERVE_KEY_ARRAY objectEnumerator];
		id key;
		while (key = [enume nextObject]) {
			[self addObserver:self forKeyPath:key options:NSKeyValueObservingOptionNew context:nil];
		}
	}
	_saveKey = [value copy];
	if (!IS_NULL_STR(_saveKey)) {
		if (first) {
			[self load];
		} else {
			[self save];
		}
	} else {
		NSEnumerator* enume = [OBSERVE_KEY_ARRAY objectEnumerator];
		id key;
		while (key = [enume nextObject]) {
			[self removeObserver:self forKeyPath:key];
		}		
	}
}

-(void) observeValueForKeyPath:(NSString*)keyPath ofObject:(id)object change:(NSDictionary*)change context:(void*)context
{
	[self save];
}

@end

@implementation PUServiceParam (Private)

-(void) save
{
	if (IS_NULL_STR(_saveKey)) {
		return;
	}
		
	PUUserDefaults* defaults = [PUUserDefaults standardUserDefaults];
	NSMutableDictionary* dic = [NSMutableDictionary dictionary];
	NSEnumerator* enume = [SAVE_KEY_ARRAY objectEnumerator];
	id key, obj;
	while (key = [enume nextObject]) {
		if (obj = [self valueForKey:key]) {
			[dic setObject:obj forKey:key];
		}
	}
	
	[defaults setObject:dic forKey:_saveKey];
	[defaults synchronize];	
}

-(void) load
{
	if (IS_NULL_STR(_saveKey)) {
		return;
	}

	PUUserDefaults* defaults = [PUUserDefaults standardUserDefaults];
	NSDictionary* dic = [[defaults objectForKey:_saveKey] copy];
	NSEnumerator* enume = [dic keyEnumerator];
	id key;
	while (key = [enume nextObject]) {
		[self setValue:[dic objectForKey:key] forKey:key];
	}
	[dic release];
}

@end
