//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "PUService.h"
#import "PUCommon.h"
#import "KeychainAccessor.h"

@implementation PUService

-(id) init
{
	if (self = [super init]) {
		m_activated = NO;
		[self setValue:[[[PUServiceSpec alloc] init] autorelease] forKey:@"spec"];
		[self setValue:[[[PUServiceParam alloc] init] autorelease] forKey:@"param"];
		
		[self addObserver:self forKeyPath:@"param.account" options:NSKeyValueObservingOptionNew context:nil];
		[self addObserver:self forKeyPath:@"param.password" options:NSKeyValueObservingOptionNew context:nil];		
	}
	return self;
}

-(void) dealloc
{
	[super dealloc];
}

-(void) observeValueForKeyPath:(NSString*)keyPath ofObject:(id)object change:(NSDictionary*)change context:(void*)context
{
	if ([keyPath isEqualTo:@"param.account"] || [keyPath isEqualTo:@"param.password"]) {
		if (!IS_NULL_STR([self valueForKeyPath:@"param.account"]) && !IS_NULL_STR([self valueForKeyPath:@"param.password"]) && m_activated) {
			[self login];
		}
	}
}

#pragma mark ___ PUService protocol ___

-(NSString*) title
{
	return @"";
}

-(void) activate
{
	[self login];
	m_activated = YES;
}

-(void) deactivate
{
	if (o_view) {
		[o_view removeFromSuperview];
	}
	m_activated = NO;
}

-(NSArray*) requestsWithPhotos:(NSArray*)photos
{
	static const char* key_paths[] = {
		"title",
		"comment",
		"keyword",
		nil,
	};
	
	PUPhoto* photo;
	PUUploadParam* param;
	NSEnumerator* enume = [photos objectEnumerator];
	PURequest* req;
	NSMutableArray* reqs = [NSMutableArray array];
	NSString* path;
//	PUImageFormat origFormat, selectedFormat;
	NSString* formatStr;
	int i;
	/*
	NSFileManager* manager = [NSFileManager defaultManager];
	[manager removeFileAtPath:@"/tmp/iphotouploader" handler:nil];
	[manager createDirectoryAtPath:@"/tmp/iphotouploader" attributes:nil];
	*/
	while (photo = [enume nextObject]) {
		req = [self createRequest:photo];
		if (!req) {
			continue;
		}
		if (path = [photo valueForKey:@"path"]) {
#if 1
			formatStr = [PUImageProcessor stringFromFormat:[PUImageProcessor formatWithPath:path]];
#else
			origFormat = [PUImageProcessor formatWithPath:path];
			selectedFormat = [[self valueForKeyPath:@"param.format"] intValue];
			NSLog(@"original format %d", origFormat);
			NSLog(@"selected format %d", selectedFormat);
			if (![[self valueForKeyPath:@"spec.formats"] containsObject:[NSNumber numberWithInt:origFormat]] && selectedFormat == kPUImageFormat_Original) {
				continue;
			}
			
			if (selectedFormat != kPUImageFormat_Original) {
				formatStr = [PUImageProcessor stringFromFormat:selectedFormat];
				NSString* dir = [NSString stringWithFormat:@"/tmp/iphotouploader/%d", [NSDate timeIntervalSinceReferenceDate]];
				[manager createDirectoryAtPath:dir attributes:nil];
				NSString* toPath = [dir stringByAppendingPathComponent:[[[path lastPathComponent] stringByDeletingPathExtension] stringByAppendingPathExtension:[formatStr lowercaseString]]];
				NSLog(@"converted path %@", toPath);
				if (![PUImageProcessor convertImage:path toPath:toPath format:selectedFormat]) {
					continue;
				}
				path = toPath;
			} else {
				formatStr = [PUImageProcessor stringFromFormat:origFormat];
			}
#endif
			param = [[PUUploadParam alloc] init];
			[param setValue:[NSURL fileURLWithPath:path] forKey:@"fileUrl"];
			[param setValue:[NSString stringWithFormat:@"image/%@", [formatStr lowercaseString]] forKey:@"contentType"];
			
			for (i = 0; ; i++) {
				const char* c_keypath = key_paths[i];
				if (!c_keypath) {
					break;
				}
				NSString* keypath = [NSString stringWithCString:c_keypath];
				if ([[self valueForKeyPath:[NSString stringWithFormat:@"spec.%@", keypath]] boolValue] && 
					[[self valueForKeyPath:[NSString stringWithFormat:@"param.%@", keypath]] boolValue]) {
					[param setValue:[photo valueForKey:keypath] forKey:keypath];
				}
			}
			NSLog(@"%@", [param description]);
			[req setValue:param forKey:@"param"];
			[param release];
			[reqs addObject:req];
		}
//		[req release];
	}
	return reqs;
}

-(PURequest*) createRequest:(PUPhoto*)photo
{
	return nil;
}

-(NSDictionary*) convertAttributes
{
	return nil;
}

-(NSURL*) URLForLastUpload:(NSArray*)responses
{
	return nil;
}

-(void) login
{
	return;
}

-(BOOL) checkAuth
{
	return (!(IS_NULL_STR([self valueForKeyPath:@"param.account"]) || IS_NULL_STR([self valueForKeyPath:@"param.password"])));
}

-(NSView*) customView
{
	return o_view;
}

@end
