//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "PURestRequest.h"
#import "PUCommon.h"

@implementation PURestRequest

-(id) responseData:(NSError**)error
{
	NSXMLDocument* xml = [super responseData:error];
	// 200番台でなければstatus codeをそのまま使う
	int errCode = (m_statusCode / 100 == 2) ? kPURequest_InvalidData : m_statusCode;
	if (!xml || *error) {
		if (!*error) {
			*error = [NSError errorWithDomain:PURequestErrorDomain code:errCode userInfo:nil];
		}
		return xml;
	}
	
	if ([xml isKindOfClass:[NSXMLDocument class]]) {
		NSXMLElement* root = [xml rootElement];
		*error = nil;
		if ([[root attributeValueForXPath:@"/rsp" andName:@"stat" error:nil] isEqualTo:@"fail"]) {
			NSArray* nodes = [root nodesForXPath:@"/rsp/err" error:nil];
			if ([nodes count] > 0) {
				// とりあえず1つめだけをとりだす
				NSXMLElement* errNode = [nodes objectAtIndex:0];
				id code = [errNode attributeValueForName:@"code"];
				id msg = [errNode attributeValueForName:@"msg"];
				NSDictionary* userInfo = (msg) ? [NSDictionary dictionaryWithObjectsAndKeys:msg, NSLocalizedDescriptionKey, nil] : nil;
				*error = [NSError errorWithDomain:PURequestErrorDomain code:([code isKindOfClass:[NSNumber class]]) ? [code intValue] : errCode userInfo:userInfo];
			}
		}
		return xml;
	} else {
		*error = [NSError errorWithDomain:PURequestErrorDomain code:errCode userInfo:nil];
	}
	return nil;
}


@end
