/*
	$Id: Account.cs 51 2010-01-28 21:55:33Z catwalk $
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Xml.Linq;
using System.Net;
using System.Net.NetworkInformation;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using Hiyoko.Net.OAuth;

namespace Hiyoko.Net.Twitter{
	public class Account{
		public AccessToken AccessToken{get; set;}
		public User User{get; private set;}
		
		public Account(){
		}
		
		public Account(AccessToken accessToken){
			this.AccessToken = accessToken;
		}
		
		public void VerifyCredential(){
			this.User = User.Empty;
			XElement xml;
			using(HttpWebResponse res = (HttpWebResponse)TwitterAPI.VerifyCredential(this.AccessToken).WebRequest.GetResponse())
			using(Stream stream = res.GetResponseStream())
			using(StreamReader reader = new StreamReader(stream, Encoding.UTF8)){
				xml = XElement.Parse(reader.ReadToEnd());
			}
			this.User = User.FromXElement(xml);
		}
		
		public User[] GetFriends(){
			XElement xml;
			var list = new List<User>();
			using(WebResponse res = TwitterAPI.GetFriends(this.AccessToken, this.User.Id, -1).WebRequest.GetResponse())
			using(Stream stream = res.GetResponseStream())
			using(StreamReader reader = new StreamReader(stream, Encoding.UTF8)){
				xml = XElement.Parse(reader.ReadToEnd());
			}
			foreach(XElement user in xml.Element("users").Elements("user")){
				list.Add(User.FromXElement(user));
			}
			return list.ToArray();
		}
		
		public bool IsVerified{
			get{
				return (this.User.Id != 0);
			}
		}
		
		public Collection<Status> GetHomeTimeline(int count, int page, long sinceId, long maxId){
			XElement xml;
			return this.GetHomeTimeline(count, page, sinceId, maxId, out xml);
		}
		
		public Collection<Status> GetHomeTimeline(int count, int page, long sinceId, long maxId, out XElement xml){
			Collection<Status> timeline = new Collection<Status>();
			string xmlString;
			using(HttpWebResponse res = (HttpWebResponse)TwitterAPI.GetHomeTimeline(this.AccessToken, count, page, sinceId, maxId).WebRequest.GetResponse())
			using(Stream stream = res.GetResponseStream())
			using(StreamReader reader = new StreamReader(stream, Encoding.UTF8)){
				xmlString = reader.ReadToEnd();
			}
			xml = XElement.Parse(xmlString);
			foreach(XElement status in xml.Elements("status")){
				timeline.Add(Status.FromXElement(status));
			}
			
			return timeline;
		}
		
		public void UpdateStatus(string status, long replyTo, string source){
			WebRequestData data = TwitterAPI.UpdateStatus(this.AccessToken, status, replyTo, source);
			data.WriteRequestData();
		}
		
		public void DestroyStatus(long id){
			WebRequestData data = TwitterAPI.DestroyStatus(this.AccessToken, id);
			data.WriteRequestData();
		}
		
		public void CreateFavorite(long id){
			WebRequestData data = TwitterAPI.CreateFavorite(this.AccessToken, id);
			data.WriteRequestData();
		}
		
		public void CreateBlock(long id){
			WebRequestData data = TwitterAPI.CreateBlock(this.AccessToken, id);
			data.WriteRequestData();
		}
		
		public void DestroyFriendship(long id){
			WebRequestData data = TwitterAPI.DestroyFriendship(this.AccessToken, id);
			data.WriteRequestData();
		}
	}
}