/*
	$Id: LinkText.cs 21 2010-01-15 01:21:50Z catwalk $
*/
using System;
using System.Configuration;
using System.Diagnostics;
using System.Windows;
using System.Windows.Data;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.Reflection;

namespace Hiyoko.Forms{
	using WinForms = System.Windows.Forms;
	using Gdi = System.Drawing;
	
	public partial class LinkText : UserControl{
		public LinkText(){
			this.InitializeComponent();
			this.Foreground = SystemColors.HotTrackBrush;
			this.hyperlink.Click += this.Hyperlink_Click;
		}
		
		private void Hyperlink_Click(object sender, RoutedEventArgs e){
			if(!String.IsNullOrEmpty(this.OpenUri)){
				try{
					Process.Start(this.OpenUri);
				}catch(Exception ex){
					MessageBox.Show("オープンに失敗しました。\n\n" + ex.Message, "Hiyoko", MessageBoxButton.OK, MessageBoxImage.Error);
				}
			}
		}
		
		private static void TextPropertyChanged(DependencyObject d, DependencyPropertyChangedEventArgs e){
			LinkText linkText = (LinkText)d;
			linkText.hyperlink.Inlines.Clear();
			string text = (string)e.NewValue;
			if(!String.IsNullOrEmpty(text)){
				linkText.hyperlink.Inlines.Add(text);
			}
		}
		
		public static readonly DependencyProperty OpenUriProperty = DependencyProperty.Register("OpenUri", typeof(string), typeof(LinkText));
		public string OpenUri{
			get{
				return (string)this.GetValue(OpenUriProperty);
			}
			set{
				this.SetValue(OpenUriProperty, value);
				this.hyperlink.ToolTip = (string)value;
			}
		}
		
		public static readonly DependencyProperty TextProperty =
			DependencyProperty.Register("Text", typeof(string), typeof(LinkText), new PropertyMetadata("", TextPropertyChanged));
		public string Text{
			get{
				return (string)this.GetValue(TextProperty);
			}
			set{
				this.SetValue(TextProperty, value);
			}
		}
		
		public static readonly DependencyProperty TextWrappingProperty =
			DependencyProperty.Register("TextWrapping", typeof(TextWrapping), typeof(LinkText), new PropertyMetadata(TextWrapping.NoWrap));
		public TextWrapping TextWrapping{
			get{
				return (TextWrapping)this.GetValue(TextWrappingProperty);
			}
			set{
				this.SetValue(TextWrappingProperty, value);
			}
		}
		
		public static readonly DependencyProperty TextTrimmingProperty =
			DependencyProperty.Register("TextTrimming", typeof(TextTrimming), typeof(LinkText), new PropertyMetadata(TextTrimming.None));
		public TextTrimming TextTrimming{
			get{
				return (TextTrimming)this.GetValue(TextTrimmingProperty);
			}
			set{
				this.SetValue(TextTrimmingProperty, value);
			}
		}
	}
}