/*
	$Id: SettingsForm.cs 24 2010-01-17 19:44:31Z catwalk $
*/
using System;
using System.Linq;
using System.ComponentModel;
using System.Configuration;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Data;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.Reflection;
using System.Net;
using Hiyoko.Net.Twitter;
using Hiyoko.Net.OAuth;
using Microsoft.WindowsAPICodePack.Shell;

namespace Hiyoko.Forms{
	using WinForms = System.Windows.Forms;
	using Gdi = System.Drawing;
	using IO = System.IO;
	
	public partial class SettingsForm : Window{
		private RequestToken requestToken = null;
		
		public SettingsForm(){
			this.InitializeComponent();
			
			this.TempSettings = new ApplicationSettings();
			Program.Settings.CopyTo(this.TempSettings);
			this.DataContext = this.TempSettings;
			this.twitpicPasswordEdit.Password = this.TempSettings.TwitpicPassword;
			
			try{
				const string none = "(None)";
				string path = IO.Path.GetDirectoryName(Program.ExecutablePath) + @"\Themes";
				this.themeComboBox.DataContext = new KeyValuePair<string, Uri>[]{new KeyValuePair<string, Uri>(none, null)}.Concat(
				                                 IO.Directory.GetFiles(path, "*.xaml")
				                                             .Select(file => new KeyValuePair<string, Uri>(IO.Path.GetFileNameWithoutExtension(file), new Uri(file)))
				                                             .Where(pair => pair.Key != none)).ToArray();
			}catch(Exception){
			}
		}
		
		private void OpenStartupScriptPath(object sender, EventArgs e){
			WinForms.OpenFileDialog dlg = new WinForms.OpenFileDialog();
			dlg.Filter = "Pyt@C|*.py";
			dlg.DefaultExt = "py";
			dlg.CheckPathExists = false;
			dlg.CheckFileExists = false;
			if(dlg.ShowDialog() == WinForms.DialogResult.OK){
				this.startupScriptPathEdit.Text = dlg.FileName;
			}
		}
		
		private void OpenAuthPageClick(object sender, EventArgs e){
			try{
				this.requestToken = TwitterAPI.ObtainUnauthorizedRequestToken();
				System.Diagnostics.Process.Start(TwitterAPI.BuildUserAuthorizationURL(this.requestToken));
				this.authRequestTokenButton.IsEnabled = true;
			}catch(WebException ex){
				MessageBox.Show(ex.Message, "ʐMs", MessageBoxButton.OK, MessageBoxImage.Error);
			}
		}
		
		private void AuthRequestTokenClick(object sender, EventArgs e){
			try{
				AccessToken accessToken = TwitterAPI.GetAccessToken(this.requestToken, this.accessTokenVerifierEdit.Text);
				this.TempSettings.AccessToken = accessToken;
				MessageBox.Show("OAuthF؂܂B", "Fؐ", MessageBoxButton.OK, MessageBoxImage.Asterisk);
			}catch(WebException ex){
				MessageBox.Show(ex.Message, "F؎s", MessageBoxButton.OK, MessageBoxImage.Error);
			}
		}
		
		private void Close_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Close_Execute(object target, ExecutedRoutedEventArgs e){
			this.Close();
		}
		
		private void Save_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Save_Execute(object target, ExecutedRoutedEventArgs e){
			this.TempSettings.TwitpicPassword = this.twitpicPasswordEdit.Password;
			this.TempSettings.CopyTo(Program.Settings);
			Program.Settings.Save();
			this.Close();
		}
		
		private void Reset_CanExecute(object target, CanExecuteRoutedEventArgs e){
			e.CanExecute = true;
		}
		
		private void Reset_Execute(object target, ExecutedRoutedEventArgs e){
			if(MessageBox.Show("ݒlɖ߂Ă낵łH", "ݒ̏", MessageBoxButton.YesNo) == MessageBoxResult.Yes){
				this.TempSettings.Reset();
			}
		}
		
		public static readonly DependencyProperty RequestTokenProperty = DependencyProperty.Register("RequestToken", typeof(RequestToken), typeof(SettingsForm));
		private RequestToken RequestToken{
			get{
				return (RequestToken)this.GetValue(RequestTokenProperty);
			}
			set{
				this.SetValue(RequestTokenProperty, value);
			}
		}
		
		public static readonly DependencyProperty TempSettingsProperty = DependencyProperty.Register("TempSettings", typeof(ApplicationSettings), typeof(SettingsForm));
		private ApplicationSettings TempSettings{
			get{
				return (ApplicationSettings)this.GetValue(TempSettingsProperty);
			}
			set{
				this.SetValue(TempSettingsProperty, value);
			}
		}
	}
}