/*
	$Id: Output.cs 6 2009-12-26 00:58:57Z catwalk $
*/
using System;
using System.Windows;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace Hiyoko.Forms{
	/// <summary>
	/// AEgvbg̃ACeIuWFNg
	/// </summary>
	public abstract class OutputItem{
		public string Text{get; set;}
		public DateTime DateTime{get; set;}
		
		public OutputItem(){
			this.DateTime = DateTime.Now;
		}
		
		public OutputItem(string text) : this(){
			this.Text = text;
		}
		
		public override string ToString(){
			return this.Text;
		}
	}
	
	public sealed class MessageOutputItem : OutputItem{
		public MessageOutputItem() : base(){}
		public MessageOutputItem(string text) : base(text){}
	}
	
	public sealed class ErrorOutputItem : OutputItem{
		public ErrorOutputItem() : base(){}
		public ErrorOutputItem(string text) : base(text){}
	}
	
	public sealed class WarningOutputItem : OutputItem{
		public WarningOutputItem() : base(){}
		public WarningOutputItem(string text) : base(text){}
	}
	
	public sealed class SuccessOutputItem : OutputItem{
		public SuccessOutputItem() : base(){}
		public SuccessOutputItem(string text) : base(text){}
	}
	
	public class OutputItemToImageSourceConverter : IValueConverter{
		private static readonly BitmapImage messageIcon;
		private static readonly BitmapImage errorIcon;
		private static readonly BitmapImage warningIcon;
		private static readonly BitmapImage successIcon;
		
		static OutputItemToImageSourceConverter(){
			messageIcon = new BitmapImage();
			messageIcon.BeginInit();
			messageIcon.UriSource = new Uri(@"/Resources/Message.png", UriKind.RelativeOrAbsolute);
			messageIcon.EndInit();
			
			errorIcon = new BitmapImage();
			errorIcon.BeginInit();
			errorIcon.UriSource = new Uri(@"/Resources/Error.png", UriKind.RelativeOrAbsolute);
			errorIcon.EndInit();
			
			warningIcon = new BitmapImage();
			warningIcon.BeginInit();
			warningIcon.UriSource = new Uri(@"/Resources/Warning.png", UriKind.RelativeOrAbsolute);
			warningIcon.EndInit();
			
			successIcon = new BitmapImage();
			successIcon.BeginInit();
			successIcon.UriSource = new Uri(@"/Resources/Success.png", UriKind.RelativeOrAbsolute);
			successIcon.EndInit();
		}
		
		public OutputItemToImageSourceConverter(){
		}
		
		public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			if(value != null){
				OutputItem item = (OutputItem)value;
				Type type = item.GetType();
				if(type == typeof(ErrorOutputItem)){
					return errorIcon;
				}else if(type == typeof(WarningOutputItem)){
					return warningIcon;
				}else if(type == typeof(SuccessOutputItem)){
					return successIcon;
				}else{
					return messageIcon;
				}
			}else{
				return messageIcon;
			}
		}
		
		public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture){
			throw new NotImplementedException();
		}
	}
}