/*
	$Id: LinkText.cs 13 2009-12-27 04:41:36Z catwalk $
*/
using System;
using System.Configuration;
using System.Windows;
using System.Windows.Data;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.Reflection;

namespace Hiyoko.Forms{
	using WinForms = System.Windows.Forms;
	using Gdi = System.Drawing;
	
	public partial class LinkText : AccessText{
		public LinkText(){
			this.Foreground = SystemColors.HotTrackBrush;
			this.Cursor = Cursors.Hand;
			this.TextDecorations = System.Windows.TextDecorations.Underline;
		}
		
		protected override void OnMouseDown(MouseButtonEventArgs e){
			base.OnMouseDown(e);
			if(e.ChangedButton == MouseButton.Left){
				if(!String.IsNullOrEmpty(this.OpenUri)){
					System.Diagnostics.Process.Start(this.OpenUri);
				}
			}
		}
		
		protected override void OnPropertyChanged(DependencyPropertyChangedEventArgs e){
			if(e.Property == OpenUriProperty){
				if(String.IsNullOrEmpty((string)e.NewValue)){
					this.Cursor = null;
					this.TextDecorations = null;
				}else{
					this.Cursor = Cursors.Hand;
					this.TextDecorations = System.Windows.TextDecorations.Underline;
				}
			}
			base.OnPropertyChanged(e);
		}
		
		public static readonly DependencyProperty OpenUriProperty = DependencyProperty.Register("OpenUri", typeof(string), typeof(LinkText));
		public string OpenUri{
			get{
				return (string)this.GetValue(OpenUriProperty);
			}
			set{
				this.SetValue(OpenUriProperty, value);
			}
		}
	}
}