/*
	$Id: Account.cs 6 2009-12-26 00:58:57Z catwalk $
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Xml.Linq;
using System.Net;
using System.Net.NetworkInformation;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;

namespace Hiyoko.Twitter{
	public class Account{
		public string Username{get; set;}
		public string Password{get; set;}
		
		public Account(string username, string password){
			this.Username = username;
			this.Password = password;
		}
		
		public Collection<Status> GetHomeTimeline(int count, int page, decimal sinceId, decimal maxId){
			XElement xml;
			return this.GetHomeTimeline(count, page, sinceId, maxId, out xml);
		}
		
		public Collection<Status> GetHomeTimeline(int count, int page, decimal sinceId, decimal maxId, out XElement xml){
			Collection<Status> timeline = new Collection<Status>();
			using(HttpWebResponse res = TwitterAPI.GetHomeTimeline(this, count, page, sinceId, maxId))
			using(Stream stream = res.GetResponseStream()){
				string xmlString;
				using(StreamReader reader = new StreamReader(stream, Encoding.UTF8)){
					xmlString = reader.ReadToEnd();
				}
				xml = XElement.Parse(xmlString);
				foreach(XElement status in xml.Elements("status")){
					timeline.Add(new Status(status));
				}
			}
			
			return timeline;
		}
		
		public void UpdateStatus(string status, decimal replyTo, string source){
			TwitterAPI.UpdateStatus(this, status, replyTo, source);
		}
		
		public void DestroyStatus(decimal id){
			TwitterAPI.DestroyStatus(this, id);
		}
		
		public void CreateFavorite(decimal id){
			TwitterAPI.CreateFavorite(this, id);
		}
		
		public void CreateBlock(decimal id){
			TwitterAPI.CreateBlock(this, id);
		}
		
		public void DestroyFriendship(decimal id){
			TwitterAPI.DestroyFriendship(this, id);
		}
	}
}