/*
	$Id: LinkText.cs 6 2009-12-26 00:58:57Z catwalk $
*/
using System;
using System.Configuration;
using System.Windows;
using System.Windows.Data;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.Reflection;

namespace Hiyoko.Forms{
	using WinForms = System.Windows.Forms;
	using Gdi = System.Drawing;
	
	public partial class LinkText : AccessText{
		public LinkText(){
			this.InitializeComponent();
		}
		
		protected override void OnMouseDown(MouseButtonEventArgs e){
			base.OnMouseDown(e);
			if(e.ChangedButton == MouseButton.Left){
				System.Diagnostics.Process.Start(this.OpenUri);
			}
		}
		
		public static readonly DependencyProperty OpenUriProperty = DependencyProperty.Register("OpenUri", typeof(string), typeof(Hyperlink));
		public string OpenUri{
			get{
				return (string)this.GetValue(OpenUriProperty);
			}
			set{
				this.SetValue(OpenUriProperty, value);
			}
		}
	}
}