; haribote-ipl
; TAB=4

CYLS	EQU		9				; ǂ܂œǂݍނ

		ORG		0x7c00			; ̃vOǂɓǂݍ܂̂

; ȉ͕WIFAT12tH[}bgtbs[fBXN̂߂̋Lq

		JMP		entry
		DB		0x90
		DB		"HARIBOTE"		; u[gZN^̖ORɏĂ悢i8oCgj
		DW		512				; 1ZN^̑傫i512ɂȂ΂Ȃj
		DB		1				; NX^̑傫i1ZN^ɂȂ΂Ȃj
		DW		1				; FATǂn܂邩iʂ1ZN^ڂɂj
		DB		2				; FAŤi2ɂȂ΂Ȃj
		DW		224				; [gfBNg̈̑傫iʂ224Ggɂj
		DW		2880			; ̃hCȗ傫i2880ZN^ɂȂ΂Ȃj
		DB		0xf0			; fBÃ^Cvi0xf0ɂȂ΂Ȃj
		DW		9				; FAT̈̒i9ZN^ɂȂ΂Ȃj
		DW		18				; 1gbNɂ̃ZN^邩i18ɂȂ΂Ȃj
		DW		2				; wbh̐i2ɂȂ΂Ȃj
		DD		0				; p[eBVgĂȂ̂ł͕K0
		DD		2880			; ̃hCu傫x
		DB		0,0,0x29		; 悭킩Ȃǂ̒lɂĂƂ炵
		DD		0xffffffff		; Ԃ{[VAԍ
		DB		"HARIBOTEOS "	; fBXN̖Oi11oCgj
		DB		"FAT12   "		; tH[}bg̖Oi8oCgj
		RESB	18				; Ƃ肠18oCgĂ

; vO{

entry:
		MOV		AX,0			; WX^
		MOV		SS,AX
		MOV		SP,0x7c00
		MOV		DS,AX

; fBXNǂ

        MOV     AX,0x0820
        MOV     ES,AX
        MOV     CH,0            ; V_0
        MOV     DH,0            ; wbh0
        MOV     CL,2            ; ZN^2
        MOV     BX,18*2-2       ; ǂݍ݂vZN^
        CALL    readfast        ; ǂݍ

        MOV     BX,4312+0x8200+2
fatloop:
        ADD     BX,-2
        CMP     WORD [BX],0
        JZ      fatloop
        MOV     AX,BX
        ADD     AX,-0x8200-5+54+53
        MOV     BL,54
        DIV     BL              ; AL = AX / BL

        CMP     AL,0
        JNZ     fatskip1
        MOV     AL,1
fatskip1:
        CMP     AL,33
        JBE     fatskip2
        MOV     AL,33
fatskip2:
        MOV     [0x0ff0],AL     ; IPLǂ܂œǂ񂾂̂
        ADD     AL,-1
        JZ      fatskip3
        MOV     AH,0
        IMUL    BX,AX,18*2

        MOV     AX,0x0c80
        MOV     ES,AX
        MOV     CH,1            ; V_1
        MOV     DH,0            ; wbh0
        MOV     CL,1            ; ZN^1
        CALL    readfast        ; ǂݍ
fatskip3:

; ǂݏÎharibote.syssI

        JMP     0xc200

error:
		MOV		AX,0
		MOV		ES,AX
		MOV		SI,msg
putloop:
		MOV		AL,[SI]
		ADD		SI,1			; SI1𑫂
		CMP		AL,0
		JE		fin
		MOV		AH,0x0e			; ꕶ\t@NV
		MOV		BX,15			; J[R[h
		INT		0x10			; rfIBIOSĂяo
		JMP		putloop
fin:
		HLT						; ܂CPU~
		JMP		fin				; [v
msg:
		DB		0x0a, 0x0a		; s2
		DB		"load error"
		DB		0x0a			; s
		DB		0

readfast:	; ALgĂł邾܂Ƃ߂ēǂݏo
;	ES:ǂݍݔԒn, CH:V_, DH:wbh, CL:ZN^, BX:ǂݍ݃ZN^

		MOV		AX,ES			; < ESAL̍őlvZ >
		SHL		AX,3			; AX32ŊāǍʂAHɓꂽƂɂȂ
		AND		AH,0x7f			; AHAH128Ŋ]i512*128=64Kj
		MOV		AL,128			; AL = 128 - AH; ԋ߂64KBE܂ōő剽ZN^邩
		SUB		AL,AH

		MOV		AH,BL			; < BXAL̍őlAHɌvZ >
		CMP		BH,0			; if (BH != 0) { AH = 18; }
		JE		.skip1
		MOV		AH,18
.skip1:
		CMP		AL,AH			; if (AL > AH) { AL = AH; }
		JBE		.skip2
		MOV		AL,AH
.skip2:

		MOV		AH,19			; < CLAL̍őlAHɌvZ >
		SUB		AH,CL			; AH = 19 - CL;
		CMP		AL,AH			; if (AL > AH) { AL = AH; }
		JBE		.skip3
		MOV		AL,AH
.skip3:

		PUSH	BX
		MOV		SI,0			; s񐔂𐔂郌WX^
retry:
		MOV		AH,0x02			; AH=0x02 : fBXNǂݍ
		MOV		BX,0
		MOV		DL,0x00			; AhCu
		PUSH	ES
		PUSH	DX
		PUSH	CX
		PUSH	AX
		INT		0x13			; fBXNBIOSĂяo
		JNC		next			; G[Ȃnext
		ADD		SI,1			; SI1𑫂
		CMP		SI,5			; SI5r
		JAE		error			; SI >= 5 error
		MOV		AH,0x00
		MOV		DL,0x00			; AhCu
		INT		0x13			; hCũZbg
		POP		AX
		POP		CX
		POP		DX
		POP		ES
		JMP		retry
next:
		POP		AX
		POP		CX
		POP		DX
		POP		BX				; ES̓eBXŎ󂯎
		SHR		BX,5			; BX16oCgPʂ512oCgPʂ
		MOV		AH,0
		ADD		BX,AX			; BX += AL;
		SHL		BX,5			; BX512oCgPʂ16oCgPʂ
		MOV		ES,BX			;  ES += AL * 0x20; ɂȂ
		POP		BX
		SUB		BX,AX
		JZ		.ret
		ADD		CL,AL			; CLAL𑫂
		CMP		CL,18			; CL18r
		JBE		readfast		; CL <= 18 readfast
		MOV		CL,1
		ADD		DH,1
		CMP		DH,2
		JB		readfast		; DH < 2 readfast
		MOV		DH,0
		ADD		CH,1
		JMP		readfast
.ret:
		RET

		RESB	0x7dfe-$		; 0x7dfe܂ł0x00Ŗ߂閽

		DB		0x55, 0xaa
