/* }EXEBhȄdˍ킹 */

#include "bootpack.h"

#define SHEET_USE		1

extern unsigned short table_8_565[256];

SheetManager *SheetManager::init(MemoryManager *memman, unsigned char *vram, int xsize, int ysize)
{
	SheetManager *sheet_manager;
	int i;
	sheet_manager = (SheetManager *) MemoryManager::allocate_4k(memman, sizeof (SheetManager));
	if (sheet_manager == 0) {
		goto err;
	}
	sheet_manager->map = (unsigned char *) MemoryManager::allocate_4k(memman, xsize * ysize);
	if (sheet_manager->map == 0) {
		MemoryManager::deallocate_4k(memman, (int) sheet_manager, sizeof (SheetManager));
		goto err;
	}
	sheet_manager->vram = vram;
	sheet_manager->xsize = xsize;
	sheet_manager->ysize = ysize;
	sheet_manager->top = -1; /* V[g͈ꖇȂ */
	for (i = 0; i < MAX_SHEETS; i++) {
		sheet_manager->sheets0[i].flags = 0; /* gp}[N */
		sheet_manager->sheets0[i].sheet_manager = sheet_manager; /* L^ */
	}
err:
	return sheet_manager;
}

Sheet *SheetManager::allocate(SheetManager *sheet_manager)
{
	Sheet *sheet;
	int i;
	for (i = 0; i < MAX_SHEETS; i++) {
		if (sheet_manager->sheets0[i].flags == 0) {
			sheet = &sheet_manager->sheets0[i];
			sheet->flags = SHEET_USE; /* gp}[N */
			sheet->height = -1; /* \ */
			sheet->task = 0;	/* ŕ@\gȂ */
			return sheet;
		}
	}
	return 0;	/* SẴV[ggp */
}

void Sheet::set_buffer(Sheet *sheet, unsigned short *buf, int xsize, int ysize, int col_inv)
{
	sheet->buf = buf;
	sheet->bxsize = xsize;
	sheet->bysize = ysize;
	if (col_inv != -1) {
		sheet->col_inv = table_8_565[col_inv];
	} else {
		sheet->col_inv = -1;
	}
	return;
}

void Sheet::refresh_map(SheetManager *sheet_manager, int vx0, int vy0, int vx1, int vy1, int h0)
{
	int h, bx, by, vx, vy, bx0, by0, bx1, by1, sid4, *p;
	unsigned short *buf;
	unsigned char sid, *map = sheet_manager->map;
	Sheet *sheet;
	if (vx0 < 0) { vx0 = 0; }
	if (vy0 < 0) { vy0 = 0; }
	if (vx1 > sheet_manager->xsize) { vx1 = sheet_manager->xsize; }
	if (vy1 > sheet_manager->ysize) { vy1 = sheet_manager->ysize; }
	for (h = h0; h <= sheet_manager->top; h++) {
		sheet = sheet_manager->sheets[h];
		sid = sheet - sheet_manager->sheets0; /* ԒnZĂԍƂėp */
		buf = sheet->buf;
		bx0 = vx0 - sheet->vx0;
		by0 = vy0 - sheet->vy0;
		bx1 = vx1 - sheet->vx0;
		by1 = vy1 - sheet->vy0;
		if (bx0 < 0) { bx0 = 0; }
		if (by0 < 0) { by0 = 0; }
		if (bx1 > sheet->bxsize) { bx1 = sheet->bxsize; }
		if (by1 > sheet->bysize) { by1 = sheet->bysize; }
		if (sheet->col_inv == -1) {
			if ((sheet->vx0 & 3) == 0 && (bx0 & 3) == 0 && (bx1 & 3) == 0) {
				/* FȂp̍Łi4oCg^j */
				bx1 = (bx1 - bx0) / 4; /* MOV */
				sid4 = sid | sid << 8 | sid << 16 | sid << 24;
				for (by = by0; by < by1; by++) {
					vy = sheet->vy0 + by;
					vx = sheet->vx0 + bx0;
					p = (int *) &map[vy * sheet_manager->xsize + vx];
					for (bx = 0; bx < bx1; bx++) {
						p[bx] = sid4;
					}
				}
			} else {
				/* FȂp̍Łi1oCg^j */
				for (by = by0; by < by1; by++) {
					vy = sheet->vy0 + by;
					for (bx = bx0; bx < bx1; bx++) {
						vx = sheet->vx0 + bx;
						map[vy * sheet_manager->xsize + vx] = sid;
					}
				}
			}
		} else {
			/* F̈ʔ */
			for (by = by0; by < by1; by++) {
				vy = sheet->vy0 + by;
				for (bx = bx0; bx < bx1; bx++) {
					vx = sheet->vx0 + bx;
					if (buf[by * sheet->bxsize + bx] != sheet->col_inv) {
						map[vy * sheet_manager->xsize + vx] = sid;
					}
				}
			}
		}
	}
	return;
}

void Sheet::refresh_sub(SheetManager *sheet_manager, int vx0, int vy0, int vx1, int vy1, int h0, int h1)
{
	SystemInfo *sysinfo = SystemInfo::get_instance();
	int h, bx, by, vx, vy, bx0, by0, bx1, by1, bx2, sid4, i, i1, *p, *q, *r;
	unsigned char *vram = sheet_manager->vram, *map = sheet_manager->map, sid;
	unsigned short *buf, sid2, *o;
	Sheet *sheet;
	/* refresh͈͂ʊOɂ͂ݏoĂ␳ */
	if (vx0 < 0) { vx0 = 0; }
	if (vy0 < 0) { vy0 = 0; }
	if (vx1 > sheet_manager->xsize) { vx1 = sheet_manager->xsize; }
	if (vy1 > sheet_manager->ysize) { vy1 = sheet_manager->ysize; }
	for (h = h0; h <= h1; h++) {
		sheet = sheet_manager->sheets[h];
		buf = sheet->buf;
		sid = sheet - sheet_manager->sheets0;
		/* vx0`vy1gāAbx0`by1tZ */
		bx0 = vx0 - sheet->vx0;
		by0 = vy0 - sheet->vy0;
		bx1 = vx1 - sheet->vx0;
		by1 = vy1 - sheet->vy0;
		if (bx0 < 0) { bx0 = 0; }
		if (by0 < 0) { by0 = 0; }
		if (bx1 > sheet->bxsize) { bx1 = sheet->bxsize; }
		if (by1 > sheet->bysize) { by1 = sheet->bysize; }
		if (sysinfo->vmode == 8) {
			/* 8rbgJ[ */
			/* 1oCg^ */
			for (by = by0; by < by1; by++) {
				vy = sheet->vy0 + by;
				for (bx = bx0; bx < bx1; bx++) {
					vx = sheet->vx0 + bx;
					if (map[vy * sheet_manager->xsize + vx] == sid) {
						vram[vy * sheet_manager->xsize + vx] = buf[by * sheet->bxsize + bx];
					}
				}
			}
		} else {
			/* 16rbgJ[ */
			if ((sheet->vx0 & 2) == 0) {
				/* 4oCg^ */
				i  = (bx0 + 1) / 2; /* bx02Ŋ́i[؂グj */
				i1 =  bx1      / 2; /* bx12Ŋ́i[؂̂āj */
				i1 = i1 - i;
				sid2 = sid | sid << 8;
				for (by = by0; by < by1; by++) {
					vy = sheet->vy0 + by;
					for (bx = bx0; bx < bx1 && (bx & 1) != 0; bx++) {	/* O̒[1oCg */
						vx = sheet->vx0 + bx;
						if (map[vy * sheet_manager->xsize + vx] == sid) {
							*(unsigned short *)	&vram[(vy * sheet_manager->xsize + vx) * 2] =
								buf[by * sheet->bxsize + bx];
						}
					}
					vx = sheet->vx0 + bx;
					o = (unsigned short *) &map[vy * sheet_manager->xsize + vx];
					q = (int   *) &vram[(vy * sheet_manager->xsize + vx) * 2];
					r = (int   *) &buf[by * sheet->bxsize + bx];
					for (i = 0; i < i1; i++) {							/* 2̔{ */
						if (o[i] == sid2) {
							q[i] = r[i];
						} else {
							bx2 = bx + i * 2;
							vx = sheet->vx0 + bx2;
							if (map[vy * sheet_manager->xsize + vx + 0] == sid) {
								*(unsigned short *)	&vram[(vy * sheet_manager->xsize + vx + 0) * 2] =
									buf[by * sheet->bxsize + bx2 + 0];
							}
							if (map[vy * sheet_manager->xsize + vx + 1] == sid) {
								*(unsigned short *)	&vram[(vy * sheet_manager->xsize + vx + 1) * 2] =
									buf[by * sheet->bxsize + bx2 + 1];
							}
						}
					}
					for (bx += i1 * 2; bx < bx1; bx++) {				/* ̒[1oCg */
						vx = sheet->vx0 + bx;
						if (map[vy * sheet_manager->xsize + vx] == sid) {
							*(unsigned short *)	&vram[(vy * sheet_manager->xsize + vx) * 2] =
								buf[by * sheet->bxsize + bx];
						}
					}
				}
			} else {
				/* 2oCg^ */
				for (by = by0; by < by1; by++) {
					vy = sheet->vy0 + by;
					for (bx = bx0; bx < bx1; bx++) {
						vx = sheet->vx0 + bx;
						if (map[vy * sheet_manager->xsize + vx] == sid) {
							*(unsigned short *)	&vram[(vy * sheet_manager->xsize + vx) * 2] =
								buf[by * sheet->bxsize + bx];
						}
					}
				}
			}
		}
	}
	return;
}

void Sheet::up_down(Sheet *sheet, int height)
{
	SheetManager *sheet_manager = sheet->sheet_manager;
	int h, old = sheet->height; /* ݒO̍L */

	/* w肪Ⴗ⍂AC */
	if (height > sheet_manager->top + 1) {
		height = sheet_manager->top + 1;
	}
	if (height < -1) {
		height = -1;
	}
	sheet->height = height; /* ݒ */

	/* ȉ͎sheets[]̕בւ */
	if (old > height) {	/* ȑOႭȂ */
		if (height >= 0) {
			/* Ԃ̂̂グ */
			for (h = old; h > height; h--) {
				sheet_manager->sheets[h] = sheet_manager->sheets[h - 1];
				sheet_manager->sheets[h]->height = h;
			}
			sheet_manager->sheets[height] = sheet;
			Sheet::refresh_map(sheet_manager, sheet->vx0, sheet->vy0, sheet->vx0 + sheet->bxsize, sheet->vy0 + sheet->bysize, height + 1);
			Sheet::refresh_sub(sheet_manager, sheet->vx0, sheet->vy0, sheet->vx0 + sheet->bxsize, sheet->vy0 + sheet->bysize, height + 1, old);
		} else {	/* \ */
			if (sheet_manager->top > old) {
				/* ɂȂĂ̂낷 */
				for (h = old; h < sheet_manager->top; h++) {
					sheet_manager->sheets[h] = sheet_manager->sheets[h + 1];
					sheet_manager->sheets[h]->height = h;
				}
			}
			sheet_manager->top--; /* \̉̂ŁAԏ̍ */
			Sheet::refresh_map(sheet_manager, sheet->vx0, sheet->vy0, sheet->vx0 + sheet->bxsize, sheet->vy0 + sheet->bysize, 0);
			Sheet::refresh_sub(sheet_manager, sheet->vx0, sheet->vy0, sheet->vx0 + sheet->bxsize, sheet->vy0 + sheet->bysize, 0, old - 1);
		}
	} else if (old < height) {	/* ȑOȂ */
		if (old >= 0) {
			/* Ԃ̂̂ */
			for (h = old; h < height; h++) {
				sheet_manager->sheets[h] = sheet_manager->sheets[h + 1];
				sheet_manager->sheets[h]->height = h;
			}
			sheet_manager->sheets[height] = sheet;
		} else {	/* \Ԃ\Ԃ */
			/* ɂȂ̂グ */
			for (h = sheet_manager->top; h >= height; h--) {
				sheet_manager->sheets[h + 1] = sheet_manager->sheets[h];
				sheet_manager->sheets[h + 1]->height = h + 1;
			}
			sheet_manager->sheets[height] = sheet;
			sheet_manager->top++; /* \̉̂ŁAԏ̍ */
		}
		Sheet::refresh_map(sheet_manager, sheet->vx0, sheet->vy0, sheet->vx0 + sheet->bxsize, sheet->vy0 + sheet->bysize, height);
		Sheet::refresh_sub(sheet_manager, sheet->vx0, sheet->vy0, sheet->vx0 + sheet->bxsize, sheet->vy0 + sheet->bysize, height, height);
	}
	return;
}

void Sheet::refresh(Sheet *sheet, int bx0, int by0, int bx1, int by1)
{
	if (sheet->height >= 0) { /* \ȂAV̏ɉĉʂ` */
		Sheet::refresh_sub(sheet->sheet_manager, sheet->vx0 + bx0, sheet->vy0 + by0, sheet->vx0 + bx1, sheet->vy0 + by1, sheet->height, sheet->height);
	}
	return;
}

void Sheet::slide(Sheet *sheet, int vx0, int vy0)
{
	SheetManager *sheet_manager = sheet->sheet_manager;
	int old_vx0 = sheet->vx0, old_vy0 = sheet->vy0;
	sheet->vx0 = vx0;
	sheet->vy0 = vy0;
	if (sheet->height >= 0) { /* \ȂAV̏ɉĉʂ` */
		Sheet::refresh_map(sheet_manager, old_vx0, old_vy0, old_vx0 + sheet->bxsize, old_vy0 + sheet->bysize, 0);
		Sheet::refresh_map(sheet_manager, vx0, vy0, vx0 + sheet->bxsize, vy0 + sheet->bysize, sheet->height);
		Sheet::refresh_sub(sheet_manager, old_vx0, old_vy0, old_vx0 + sheet->bxsize, old_vy0 + sheet->bysize, 0, sheet->height - 1);
		Sheet::refresh_sub(sheet_manager, vx0, vy0, vx0 + sheet->bxsize, vy0 + sheet->bysize, sheet->height, sheet->height);
	}
	return;
}

void Sheet::deallocate(Sheet *sheet)
{
	if (sheet->height >= 0) {
		Sheet::up_down(sheet, -1); /* \Ȃ܂\ɂ */
	}
	sheet->flags = 0; /* gp}[N */
	return;
}
