/* ֌W */

#include "bootpack.h"

#define EFLAGS_AC_BIT		0x00040000
#define CR0_CACHE_DISABLE	0x60000000

unsigned int MemoryManager::test(unsigned int start, unsigned int end)
{
	char flg486 = 0;
	unsigned int eflg, cr0, i;

	/* 386A486ȍ~Ȃ̂̊mF */
	eflg = io_load_eflags();
	eflg |= EFLAGS_AC_BIT; /* AC-bit = 1 */
	io_store_eflags(eflg);
	eflg = io_load_eflags();
	if ((eflg & EFLAGS_AC_BIT) != 0) { /* 386łAC=1ɂĂ0ɖ߂Ă܂ */
		flg486 = 1;
	}
	eflg &= ~EFLAGS_AC_BIT; /* AC-bit = 0 */
	io_store_eflags(eflg);

	if (flg486 != 0) {
		cr0 = load_cr0();
		cr0 |= CR0_CACHE_DISABLE; /* LbV֎~ */
		store_cr0(cr0);
	}

	i = memtest_sub(start, end);

	if (flg486 != 0) {
		cr0 = load_cr0();
		cr0 &= ~CR0_CACHE_DISABLE; /* LbV */
		store_cr0(cr0);
	}

	return i;
}

void MemoryManager::init(MemoryManager *man)
{
	man->frees = 0;			/* ̌ */
	man->maxfrees = 0;		/* 󋵊ώ@pFfrees̍ől */
	man->lostsize = 0;		/* ɎsvTCY */
	man->losts = 0;			/* Ɏs */
	return;
}

unsigned int MemoryManager::total(MemoryManager *man)
/* TCY̍v */
{
	unsigned int i, t = 0;
	for (i = 0; i < man->frees; i++) {
		t += man->freeinfo[i].size;
	}
	return t;
}

unsigned int MemoryManager::allocate(MemoryManager *man, unsigned int size)
/* m */
{
	unsigned int i, a;
	for (i = 0; i < man->frees; i++) {
		if (man->freeinfo[i].size >= size) {
			/* \ȍL̂𔭌 */
			a = man->freeinfo[i].addr;
			man->freeinfo[i].addr += size;
			man->freeinfo[i].size -= size;
			if (man->freeinfo[i].size == 0) {
				/* freeinfo[i]ȂȂ̂őOւ߂ */
				man->frees--;
				for (; i < man->frees; i++) {
					man->freeinfo[i] = man->freeinfo[i + 1]; /* \̂̑ */
				}
			}
			return a;
		}
	}
	return 0; /* Ȃ */
}

int MemoryManager::deallocate(MemoryManager *man, unsigned int addr, unsigned int size)
/*  */
{
	int i, j;
	/* ܂Ƃ߂₷lƁAfreeinfo[]addrɕłق */
	/* ܂Aǂɓׂ߂ */
	for (i = 0; i < man->frees; i++) {
		if (man->freeinfo[i].addr > addr) {
			break;
		}
	}
	/* freeinfo[i - 1].addr < addr < freeinfo[i].addr */
	if (i > 0) {
		/* O */
		if (man->freeinfo[i - 1].addr + man->freeinfo[i - 1].size == addr) {
			/* Ô̈ɂ܂Ƃ߂ */
			man->freeinfo[i - 1].size += size;
			if (i < man->frees) {
				/*  */
				if (addr + size == man->freeinfo[i].addr) {
					/* ȂƌƂ܂Ƃ߂ */
					man->freeinfo[i - 1].size += man->freeinfo[i].size;
					/* man->freeinfo[i]̍폜 */
					/* freeinfo[i]ȂȂ̂őOւ߂ */
					man->frees--;
					for (; i < man->frees; i++) {
						man->freeinfo[i] = man->freeinfo[i + 1]; /* \̂̑ */
					}
				}
			}
			return 0; /* I */
		}
	}
	/* OƂ͂܂Ƃ߂Ȃ */
	if (i < man->frees) {
		/* 낪 */
		if (addr + size == man->freeinfo[i].addr) {
			/* Ƃ͂܂Ƃ߂ */
			man->freeinfo[i].addr = addr;
			man->freeinfo[i].size += size;
			return 0; /* I */
		}
	}
	/* Oɂɂ܂Ƃ߂Ȃ */
	if (man->frees < MEMMAN_FREES) {
		/* freeinfo[i]Aւ炵āA܂ */
		for (j = man->frees; j > i; j--) {
			man->freeinfo[j] = man->freeinfo[j - 1];
		}
		man->frees++;
		if (man->maxfrees < man->frees) {
			man->maxfrees = man->frees; /* őlXV */
		}
		man->freeinfo[i].addr = addr;
		man->freeinfo[i].size = size;
		return 0; /* I */
	}
	/* ɂ点Ȃ */
	man->losts++;
	man->lostsize += size;
	return -1; /* sI */
}

unsigned int MemoryManager::allocate_4k(MemoryManager *man, unsigned int size)
{
	unsigned int a;
	size = (size + 0xfff) & 0xfffff000;
	a = MemoryManager::allocate(man, size);
	return a;
}

int MemoryManager::deallocate_4k(MemoryManager *man, unsigned int addr, unsigned int size)
{
	int i;
	size = (size + 0xfff) & 0xfffff000;
	i = MemoryManager::deallocate(man, addr, size);
	return i;
}
