#include "bootpack.h"
#include <string.h>

#define BLACK		0x0000
#define LIGHT_RED	0xf800
#define LIGHT_GREEN  0x07e0
#define LIGHT_YELLOW 0xffe0
#define LIGHT_BLUE   0x001f
#define LIGHT_PURPLE 0xf81f
#define LIGHT_AQUA   0x07ff
#define WHITE		0xffff
#define LIGHT_GRAY   0xc618
#define DARK_RED	 0x8000
#define DARK_GREEN   0x0420
#define DARK_YELLOW  0x8420
#define DARK_BLUE	0x0010
#define DARK_PURPLE  0x8010
#define DARK_AQUA	0x0410
#define DARK_GRAY	0x8410

#define FONT_W		6
#define FONT_H	   12

#define inGetUInt16(b) (unsigned short)((unsigned short)((b)[1]) << 8 | (unsigned short)((b)[0]))

unsigned char *Gui::fontdata = 0;
int *Gui::offsets = 0;

void Gui::init(int *fat, MemoryManager *memory_manager, unsigned short *vram, int x, int y)
/*  */
{
	/* wihԂ */
	for (int i = 0; i < x * y; i++) {
		vram[i] = 0xDF1F;
	}

	/* shgoth12.fnt̓ǂݍ */
	FileInfo *finfo = File::search("shgoth12.fnt", (FileInfo *) (ADR_DISKIMG + 0x002600), 224);
	if (finfo != 0) {
		int size = finfo->size;
		Gui::fontdata = File::load_file2(finfo->clustno, &size, fat);
		if (Gui::fontdata != 0) {
			Gui::offsets  = (int *) MemoryManager::allocate_4k(memory_manager, 65536);
			if (Gui::offsets != 0) {
				int num = inGetUInt16(&Gui::fontdata[0]);
				int pos = 4;
				for (int i = 0; i < num; i++) {
					int fcode = inGetUInt16(&Gui::fontdata[pos]);
					offsets[fcode] = pos;
					pos += 4;
					unsigned char fw = Gui::fontdata[pos++];
					unsigned char fh = Gui::fontdata[pos++];
					pos += (int)((fw  *fh + 7) / 8);
				}
			}
		}
	}
}

void Gui::drawPixel(Sheet *sheet, int x, int y, unsigned short col)
/* _ł */
{
	int tx = 0;
	int ty = 0;
	int cw = sheet->bxsize;

	sheet->buf[(tx + x) + cw  *(ty + y)] = col;
}

void Gui::drawLine(Sheet *sheet, int x0, int y0, int x1, int y1, unsigned short col)
/*  */
{
	int tx = 0;
	int ty = 0;
	int cw = sheet->bxsize;
	int dx = (x0 > x1) ? (x0 - x1) : (x1 - x0);
	int dy = (y0 > y1) ? (y0 - y1) : (y1 - y0);

	if (dx == 0 && dy == 0) {
		sheet->buf[(tx + x0) + cw  *(ty + y0)] = col;
	} else if (dx >= dy) {
		if (x0 > x1) {
			int tx = x0;
			x0 = x1;
			x1 = tx;
			int ty = y0;
			y0 = y1;
			y1 = ty;
		}
		for (int x = x0; x <= x1; x++) {
			sheet->buf[(tx + x) + cw  *(ty + ((2  *y0 + 2  *(y1 - y0)  *(x - x0) / (x1 - x0)) + 1) / 2)] = col;
		}
	} else {
		if (y0 > y1) {
			int tx = x0;
			x0 = x1;
			x1 = tx;
			int ty = y0;
			y0 = y1;
			y1 = ty;
		}
		for (int y = y0; y <= y1; y++) {
			sheet->buf[(tx + (2  *x0 + 2  *(x1 - x0)  *(y - y0) / (y1 - y0) + 1) / 2) + cw  *(ty + y)] = col;
		}
	}
}

void Gui::drawRect(Sheet *sheet, int x, int y, int width, int height, unsigned short col)
/* `` */
{
	int tx = 0;
	int ty = 0;
	int cw = sheet->bxsize;
	int xw = x + width  - 1;
	int yh = y + height - 1;

	for (int xx = x; xx <= xw; xx++) {
		sheet->buf[(tx + xx) + cw  *(ty + y)]  = col;
		sheet->buf[(tx + xx) + cw  *(ty + yh)] = col;
	}
	for (int yy = y + 1; yy <= yh - 1; yy++) {
		sheet->buf[(tx + x)  + cw  *(ty + yy)] = col;
		sheet->buf[(tx + xw) + cw  *(ty + yy)] = col;
	}
}

void Gui::fillRect(Sheet *sheet, int x0, int y0, int x1, int y1, unsigned short col)
/* `hԂ */
{
	int tx = 0;
	int ty = 0;
	int cw = sheet->bxsize;

	for (int y = y0; y < y0 + y1; y++) {
		for (int x = x0; x < x0 + x1; x++) {
			sheet->buf[(tx + x) + cw  *(ty + y)] = col;
		}
	}
}

void Gui::drawString(Sheet *sheet, char *title, int x0, int y0, unsigned short col, StringInfo *info)
/* `悷 */
{
	int bw = 0, bh = FONT_H, length = 0;
	int sw = sheet != 0 ? sheet->bxsize : 0;

	if (Gui::fontdata == 0 || Gui::offsets == 0) return;

	int I  = strlen(title);
	for (int i = 0; i < I;) {
		unsigned short ucs2 = 0;
		unsigned char c = title[i] & 0xe0;
		if (c < 0x80) {
			ucs2 = (unsigned short) title[i];
			i++;
		} else if (c < 0xe0) {
			ucs2 = (unsigned short) title[i] & 0x1f;
			i++;
			ucs2 = ucs2 << 6;
			ucs2 = ucs2 | ((unsigned short) title[i] & 0x3f);
			i++;
		} else if (c < 0xf0) {
			ucs2 = (unsigned short) title[i] & 0x0f;
			i++;
			ucs2 = ucs2 << 6;
			ucs2 = ucs2 | ((unsigned short) title[i] & 0x3f);
			i++;
			ucs2 = ucs2 << 6;
			ucs2 = ucs2 | ((unsigned short) title[i] & 0x3f);
			i++;
		}

		int offset = offsets[ucs2] + 4;
		if (offset != 0) {
			unsigned char fw = Gui::fontdata[offset++];
			unsigned char fh = Gui::fontdata[offset++];
			if (sw > 0) {
				int bit = 1;
				for (int y = 0; y < fh; y++) {
					for (int x = 0; x < fw; x++) {
						if ((Gui::fontdata[offset] & bit) != 0) {
							sheet->buf[(x0 + x + bw) + sw  *(y0 + y)] = col;
						}
						bit <<= 1;
						if (bit == 256) {
							offset++;
							bit = 1;
						}
					}
				}
			}
			bw += fw;
			length++;
		}
	}
	if (info != 0) {
		info->width  = bw;
		info->height = bh;
		info->length = length;
	}
}

void Gui::drawTitle(Sheet *sheet, bool active)
/* ^Cg`悷 */
{
	int w = sheet->bxsize;

	/* {^ */
	static unsigned char icon_close_data [] = 
	{
		 0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x2,
		 0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,
		 0x1,0x0,0x8,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x0,0x8,
		 0x1,0x0,0x2,0x5,0x5,0x3,0x3,0x7,0x7,0x2,0x1,0x0,0x8,
		 0x1,0x0,0x2,0x5,0x3,0x3,0x7,0x7,0x2,0x2,0x1,0x0,0x8,
		 0x1,0x0,0x2,0x3,0x3,0x7,0x7,0x2,0x2,0x6,0x1,0x0,0x8,
		 0x1,0x0,0x2,0x3,0x7,0x7,0x2,0x2,0x6,0x6,0x1,0x0,0x8,
		 0x1,0x0,0x2,0x7,0x7,0x2,0x2,0x6,0x6,0x4,0x1,0x0,0x8,
		 0x1,0x0,0x2,0x7,0x2,0x2,0x6,0x6,0x4,0x4,0x1,0x0,0x8,
		 0x1,0x0,0x2,0x2,0x2,0x6,0x6,0x4,0x4,0x8,0x1,0x0,0x8,
		 0x1,0x0,0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x0,0x8,
		 0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,
		 0x2,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,
	 };
	static unsigned short icon_close_pallete [] =
	{
		0x18c3,
		0x8c71,
		0xce79,
		0xad75,
		0xef7d,
		0x9cf3,
		0xdefb,
		0xbdf7,
		0xffff,
	};

	/* ^Cg̈hԂ */
	fillRect(sheet, 3, 3, w - 6, 17, LIGHT_GRAY);

	/* {^ */
	if (active) {
		for (int y = 0; y < 13; y++) {
			for (int x = 0; x < 13; x++) {
				sheet->buf[(y + 4) * w + (x + 4)] =
					icon_close_pallete[icon_close_data[y  *13 + x]];
			}
		}
	}

	/* ^Cg */
	StringInfo info;
	Gui::drawString(0, sheet->title, 0, 0, 0, &info);
	int L = info.width + FONT_W;
	int W = (w - L) / 2;

	/* ^Cg */
	if (active) {
		for (int y = 4; y <= 14; y += 2) {
			Gui::drawLine(sheet, 21, y, W - 1, y, WHITE);
			Gui::drawLine(sheet, 22, y + 1, W, y + 1, DARK_GRAY);
			Gui::drawLine(sheet, W + L, y, w - 6, y, WHITE);
			Gui::drawLine(sheet, W + L + 1, y + 1, w - 5, y + 1, DARK_GRAY);
		}
	}

	/* ^Cg */
	if (active) {
		Gui::drawString(sheet, sheet->title, W + FONT_W / 2, ((22 - FONT_H) / 2), BLACK);
		Gui::drawString(sheet, sheet->title, W + FONT_W / 2 + 1, ((22 - FONT_H) / 2), BLACK);
	} else {
		Gui::drawString(sheet, sheet->title, W + FONT_W / 2, ((22 - FONT_H) / 2), DARK_GRAY);
	}

	/* `XV */
	Sheet::refresh(sheet, 0, 0, w, 20);
}

void Gui::drawFrame(Sheet *sheet, char *title)
/* g` */
{
	int w = sheet->bxsize;
	int h = sheet->bysize;

	/* wihԂ */
	fillRect(sheet, 0, 0, w, h, LIGHT_GRAY);

	/* Og */
	Gui::drawRect(sheet, 0, 0, w, h, BLACK);

	/* g */
	Gui::drawRect(sheet, 5, 21, w - 10, h - 26, BLACK);

	/*  */
	Gui::drawLine(sheet, 4, 20, 4, h - 6,  DARK_GRAY);
	Gui::drawLine(sheet, 4, 20, w - 6, 20, DARK_GRAY);
	Gui::drawLine(sheet, w - 5, 21, w - 5, h - 6, WHITE);
	Gui::drawLine(sheet, 4, h - 5,  w - 5, h - 5, WHITE);
	Gui::drawLine(sheet, 1, 1, 1, h - 3, WHITE);
	Gui::drawLine(sheet, 1, 1, w - 3, 1, WHITE);
	Gui::drawLine(sheet, w - 2, 2, w - 2, h - 2, DARK_GRAY);
	Gui::drawLine(sheet, 2, h - 2, w - 3, h - 2, DARK_GRAY);

	/* ^Cg */
	sheet->title = title;
	Gui::drawTitle(sheet, true);
}
