#if (defined(__cplusplus))
extern "C" {
#endif

/* asmhead.nas */

#define ADR_SYSTEMINFO	0x00000ff0
#define ADR_DISKIMG		0x00100000

/* naskfunc.nas */

void io_hlt(void);
void io_cli(void);
void io_sti(void);
void io_stihlt(void);
int io_in8(int port);
void io_out8(int port, int data);
int io_load_eflags(void);
void io_store_eflags(int eflags);
void load_gdtr(int limit, int addr);
void load_idtr(int limit, int addr);
int load_cr0(void);
void store_cr0(int cr0);
void load_tr(int tr);
void clts(void);
void fnsave(int *addr);
void frstor(int *addr);
void asm_inthandler07(void);
void asm_inthandler0c(void);
void asm_inthandler0d(void);
void asm_inthandler20(void);
void asm_inthandler21(void);
void asm_inthandler27(void);
void asm_inthandler2c(void);
unsigned int memtest_sub(unsigned int start, unsigned int end);
void farjmp(int eip, int cs);
void farcall(int eip, int cs);
void asm_hrb_api(void);
void start_app(int eip, int cs, int esp, int ds, int *tss_esp0);
void asm_end_app(void);

/* queue.c */

/* graphic.c */

#define COL8_000000		0
#define COL8_FF0000		1
#define COL8_00FF00		2
#define COL8_FFFF00		3
#define COL8_0000FF		4
#define COL8_FF00FF		5
#define COL8_00FFFF		6
#define COL8_FFFFFF		7
#define COL8_C6C6C6		8
#define COL8_840000		9
#define COL8_008400		10
#define COL8_848400		11
#define COL8_000084		12
#define COL8_840084		13
#define COL8_008484		14
#define COL8_848484		15

/* dsctbl.c */

#define ADR_IDT			0x0026f800
#define LIMIT_IDT		0x000007ff
#define ADR_GDT			0x00270000
#define LIMIT_GDT		0x0000ffff
#define ADR_BOTPAK		0x00280000
#define LIMIT_BOTPAK	0x0007ffff
#define AR_DATA32_RW	0x4092
#define AR_CODE32_ER	0x409a
#define AR_LDT			0x0082
#define AR_TSS32		0x0089
#define AR_INTGATE32	0x008e

/* int.c */

void inthandler27(int *esp);

#define PIC0_ICW1		0x0020
#define PIC0_OCW2		0x0020
#define PIC0_IMR		0x0021
#define PIC0_ICW2		0x0021
#define PIC0_ICW3		0x0021
#define PIC0_ICW4		0x0021
#define PIC1_ICW1		0x00a0
#define PIC1_OCW2		0x00a0
#define PIC1_IMR		0x00a1
#define PIC1_ICW2		0x00a1
#define PIC1_ICW3		0x00a1
#define PIC1_ICW4		0x00a1

/* keyboard.c */

void inthandler21(int *esp);

#define PORT_KEYDAT		0x0060
#define PORT_KEYCMD		0x0064

/* mouse.c */

void inthandler2c(int *esp);

/* memory.c */

#define MEMMAN_FREES		4090	/* Ŗ32KB */
#define MEMMAN_ADDR			0x003c0000

/* sheet.c */

#define MAX_SHEETS		256

/* timer.c */

#define MAX_TIMER		500

void inthandler20(int *esp);

/* mtask.c */

#define MAX_TASKS		1000	/* ő^XN */
#define TASK_GDT0		3		/* TSSGDT̉Ԃ犄蓖Ă̂ */
#define MAX_TASKS_LV	100
#define MAX_TASKLEVELS	10

int *inthandler07(int *esp);

/* window.c */

/* console.c */

int *hrb_api(int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
int *inthandler0d(int *esp);
int *inthandler0c(int *esp);

/* file.c */

/* tek.c */

int tek_getsize(unsigned char *p);
int tek_decomp(unsigned char *p, unsigned char *q, int size);

/* bootpack.c */

void HariMain(void);

#if (defined(__cplusplus))
}
#endif

/* asmhead.nas */

class SystemInfo { /* 0x0ff0-0x0fff */
public:
	char cyls; /* u[gZN^͂ǂ܂ŃfBXNǂ񂾂̂ */
	char leds; /* u[g̃L[{[hLED̏ */
	char vmode; /* rfI[h  rbgJ[ */
	char reserve;
	short scrnx, scrny; /* ʉ𑜓x */
	unsigned char *vram;
	
public:
	static SystemInfo *get_instance(void) {
		SystemInfo *sysinfo = (SystemInfo *) ADR_SYSTEMINFO;
		return sysinfo;
	}
};

/* queue.cpp */

class Task;
class Queue {
public:
	int *buf;
	int p, q, size, free, flags;
	Task *task;

public:
	static void init(Queue *queue, int size, int *buf, Task *task);
	static int push(Queue *queue, int data);
	static int pop(Queue *queue);
	static int status(Queue *queue);
};

/* graphic.cpp */

class Palette {
public:
	static void init(void);
	static void set(int start, int end, unsigned char *rgb);
};

class Graphics {
public:
	//static void init(unsigned short *vram, int x, int y);
	static void fill_rect(unsigned short *vram, int xsize, unsigned char c, int x0, int y0, int x1, int y1);
	//static void draw_string(unsigned short *vram, int xsize, int x, int y, char c, char *s);
private:
	//static void draw_char(unsigned short *vram, int xsize, int x, int y, char c, char *font);
};

/* descriptor.cpp */

class Descriptor {
public:
	static void init(void);
};

class SegmentDescriptor {
public:
	short limit_low, base_low;
	char base_mid, access_right;
	char limit_high, base_high;
	
public:
	static void set(SegmentDescriptor *sd, unsigned int limit, int base, int ar);
};

class GateDescriptor {
public:
	short offset_low, selector;
	char dw_count, access_right;
	short offset_high;
	
public:
	static void set(GateDescriptor *gd, int offset, int selector, int ar);
};

/* pic.cpp */

class PIC {
public:
	static void init(void);
};

/* keyboard.cpp */

class Keyboard {
public:
	static void init(Queue *queue, int data0);
	static void sendready(void);
};

/* mouse.cpp */

class MouseCursor {
public:
	static void init(unsigned short *mouse, char bc);
};

class Mouse {
public:
	unsigned char buf[4], phase;
	int x, y, btn, scroll, scrollmode;

public:
	static void init(Queue *queue, int data0, Mouse *mouse);
	static int decode(Mouse *mouse, unsigned char dat);
};

/* memory.cpp */

class FreeInfo {
public:
	unsigned int addr, size;
};

class MemoryManager {
public:
	int frees, maxfrees, lostsize, losts;
	FreeInfo freeinfo[MEMMAN_FREES];
	
public:
	static unsigned int test(unsigned int start, unsigned int end);
	static void init(MemoryManager *man);
	static unsigned int total(MemoryManager *man);
	static unsigned int allocate(MemoryManager *man, unsigned int size);
	static int deallocate(MemoryManager *man, unsigned int addr, unsigned int size);
	static unsigned int allocate_4k(MemoryManager *man, unsigned int size);
	static int deallocate_4k(MemoryManager *man, unsigned int addr, unsigned int size);
};

/* file.cpp */

class FileHandle {
public:
	unsigned char *buf;
	int size;
	int pos;
};

class FileInfo {
public:
	unsigned char name[8], ext[3], type;
	char reserve[10];
	unsigned short time, date, clustno;
	unsigned int size;
};

class File {
public:
	static void read_fat(int *fat, unsigned char *img);
	static FileInfo *search(char *name, FileInfo *finfo, int max);
	static unsigned char *load_file2(int clustno, int *psize, int *fat);
private:
	static void load_file(int clustno, int size, unsigned char *buf, int *fat, unsigned char *img);
};

/* sheet.cpp */

class SheetManager;
class Sheet {
public:
	unsigned short *buf;
	int bxsize, bysize, vx0, vy0, col_inv, height, flags;
	SheetManager *sheet_manager;
	Task *task;
	char *title;

public:
	static void set_buffer(Sheet *sheet, unsigned short *buf, int xsize, int ysize, int col_inv);
	static void up_down(Sheet *sheet, int height);
	static void refresh(Sheet *sheet, int bx0, int by0, int bx1, int by1);
	static void slide(Sheet *sheet, int vx0, int vy0);
	static void deallocate(Sheet *sheet);
private:
	static void refresh_map(SheetManager *sheet_manager, int vx0, int vy0, int vx1, int vy1, int h0);
	static void refresh_sub(SheetManager *sheet_manager, int vx0, int vy0, int vx1, int vy1, int h0, int h1);
};

class SheetManager {
public:
	unsigned char *vram, *map;
	int xsize, ysize, top;
	Sheet *sheets[MAX_SHEETS];
	Sheet sheets0[MAX_SHEETS];

public:
	static SheetManager *init(MemoryManager *memory_manager, unsigned char *vram, int xsize, int ysize);
	static Sheet *allocate(SheetManager *sheet_manager);
};

class StringInfo {
public:
	int width, height, length;
};

class Gui {
public:
	static unsigned char *fontdata;
	static int *offsets;
	
public:
	static void init(int *fat, MemoryManager *memory_manager, unsigned short *vram, int x, int y);
	static void drawPixel(Sheet *sheet, int x, int y, unsigned short col);
	static void drawLine(Sheet *sheet, int x0, int y0, int x1, int y1, unsigned short col);
	static void drawRect(Sheet *sheet, int x, int y, int width, int height, unsigned short col);
	static void fillRect(Sheet *sheet, int x0, int y0, int x1, int y1, unsigned short col);
	static void drawString(Sheet *sheet, char *title, int x0, int y0, unsigned short col, StringInfo *info = 0);
	static void drawTitle(Sheet *sheet, bool active);
	static void drawFrame(Sheet *sheet, char *title);
};

/* timer.cpp */

class PIT {
public:
	static void init(void);
};

class Timer {
public:
	Timer *next;
	unsigned int timeout;
	char flags, flags2;
	Queue *queue;
	int data;
	
public:
	static Timer *allocate(void);
	static void deallocate(Timer *timer);
	static void init(Timer *timer, Queue *queue, int data);
	static void set_time(Timer *timer, unsigned int timeout);
	static int cancel(Timer *timer);
	static void cancel_all(Queue *queue);
};

class TimerManager {
public:
	unsigned int count, next;
	Timer *t0;
	Timer *timers0;

public:
	static void init(void);
};

extern TimerManager timer_manager;

/* console.c */

class Console {
public:
	Sheet *sheet;
	int cur_x, cur_y, cur_c;
	Timer *timer;
	
public:
	static void put_char(Console *console, int chr, char move);
	static void new_line(Console *console);
	static void put_str0(Console *console, char *s);
	static void put_str1(Console *console, char *s, int l);
	static void run_command(char *cmdline, Console *console, int *fat, int memtotal);
	static void command_mem(Console *console, int memtotal);
	static void command_cls(Console *console);
	static void command_dir(Console *console);
	static void command_exit(Console *console, int *fat);
	static void command_start(Console *console, char *cmdline, int memtotal);
	static void command_ncst(Console *console, char *cmdline, int memtotal);
	static void command_langmode(Console *console, char *cmdline);
	static int command_app(Console *console, int *fat, char *cmdline);
	static void hrb_api_linewin(Sheet *sheet, int x0, int y0, int x1, int y1, int col);
};

void console_task(Sheet *sheet, int memtotal);

/* mtask.cpp */

class TSS32 {
public:
	int backlink, esp0, ss0, esp1, ss1, esp2, ss2, cr3;
	int eip, eflags, eax, ecx, edx, ebx, esp, ebp, esi, edi;
	int es, cs, ss, ds, fs, gs;
	int ldtr, iomap;
};

class Task {
public:
	int sel, flags; /* selGDT̔ԍ̂ */
	int level, priority;
	Queue queue;
	TSS32 tss;
	int fpu[108 / 4];
	SegmentDescriptor ldt[2];
	Console *console;
	int ds_base, console_stack;
	FileHandle *fhandle;
	int *fat;
	char *cmdline;
	unsigned char langmode, langbyte1;
	
public:
	static Task *now(void);
	static Task *init(MemoryManager *memory_manager);
	static Task *allocate(void);
	static void run(Task *task, int level, int priority);
	static void switcher(void);
	static void sleep(Task *task);
private:
	static void add(Task *task);
	static void remove(Task *task);
	static void switch_sub(void);
};

class TaskLevel {
public:
	int running; /* 삵Ă^XN̐ */
	int now; /* ݓ삵Ă^XNǂꂾ悤ɂ邽߂̕ϐ */
	Task *tasks[MAX_TASKS_LV];
};

struct TaskManager {
public:
	int now_lv; /* ݓ쒆̃x */
	Task *task_fpu;
	char lv_change; /* ^XNXCb`̂ƂɁAxςقǂ */
	TaskLevel level[MAX_TASKLEVELS];
	Task tasks0[MAX_TASKS];
};

extern TaskManager *task_manager;
extern Timer *task_timer;

/* window.c */

class Window {
public:
	//static void make_window(unsigned short *buf, int xsize, int ysize, char *title, char act);
	static void putfonts_asc_sheet(Sheet *sheet, int x, int y, int c, int b, char *s, int l);
	//static void make_textbox(Sheet *sheet, int x0, int y0, int sx, int sy, int c);
	//static void make_wtitle(unsigned short *buf, int xsize, char *title, char act);
	//static void change_wtitle(Sheet *sheet, char act);
};

/* bootpack.cpp */

Task *open_console_task(Sheet *sheet, unsigned int memtotal);
Sheet *open_console(SheetManager *sheet_manager, unsigned int memtotal);

