/* bootpack̃C */

#include "bootpack.h"
#include <stdio.h>

#define KEYCMD_LED		0xed

void keywin_off(Sheet *key_win);
void keywin_on(Sheet *key_win);
void close_console(Sheet *sheet);
void close_console_task(Task *task);

void HariMain(void)
{
	SystemInfo *sysinfo = SystemInfo::get_instance();
	SheetManager *sheet_manager;
	char s[40];
	Queue queue, keycmd;
	int queuebuf[128], keycmd_buf[32];
	int mx, my, i, new_mx = -1, new_my = 0, new_wx = 0x7fffffff, new_wy = 0;
	unsigned int memtotal;
	Mouse mouse;
	MemoryManager *memory_manager = (MemoryManager *) MEMMAN_ADDR;
	unsigned short *buf_back, buf_mouse[11 * 17];
	Sheet *sheet_back, *sheet_mouse;
	Task *task_a, *task;
	static char keytable0[0x80] = {
		0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0x5c, 0,  0,   0,   0,   0,   0,   0,   0,   0,   0x5c, 0,  0
	};
	static char keytable1[0x80] = {
		0,   0,   '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~', '=', '~', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '`', '{', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', '+', '*', 0,   0,   '}', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   '_', 0,   0,   0,   0,   0,   0,   0,   0,   0,   '|', 0,   0
	};
	int key_shift = 0, key_leds = (sysinfo->leds >> 4) & 7, keycmd_wait = -1;
	int j, x, y, mmx = -1, mmy = -1, mmx2 = 0;
	Sheet *sheet = 0, *key_win, *sheet2;
	int *fat;
	unsigned char *nihongo;
	FileInfo *finfo;
	extern char hankaku[4096];

	Descriptor::init();
	PIC::init();
	io_sti(); /* IDT/PIC̏ÎCPŮ荞݋֎~ */
	Queue::init(&queue, 128, queuebuf, 0);
	*((int *) 0x0fec) = (int) &queue;
	PIT::init();
	Keyboard::init(&queue, 256);
	Mouse::init(&queue, 512, &mouse);
	io_out8(PIC0_IMR, 0xf8); /* PITPIC1ƃL[{[h(11111000) */
	io_out8(PIC1_IMR, 0xef); /* }EX(11101111) */
	Queue::init(&keycmd, 32, keycmd_buf, 0);

	memtotal = MemoryManager::test(0x00400000, 0xbfffffff);
	MemoryManager::init(memory_manager);
	MemoryManager::deallocate(memory_manager, 0x00001000, 0x0009e000); /* 0x00001000 - 0x0009efff */
	MemoryManager::deallocate(memory_manager, 0x00400000, memtotal - 0x00400000);

	TimerManager::init();
	Palette::init();
	sheet_manager = SheetManager::init(memory_manager, sysinfo->vram, sysinfo->scrnx, sysinfo->scrny);
	task_a = Task::init(memory_manager);
	queue.task = task_a;
	Task::run(task_a, 1, 2);
	*((int *) 0x0fe4) = (int) sheet_manager;
	task_a->langmode = 0;

	/* fat */
	fat = (int *) MemoryManager::allocate_4k(memory_manager, 4 * 2880);
	File::read_fat(fat, (unsigned char *) (ADR_DISKIMG + 0x000200));

	/* sheet_back */
	sheet_back  = SheetManager::allocate(sheet_manager);
	buf_back  = (unsigned short *) MemoryManager::allocate_4k(memory_manager, sysinfo->scrnx * sysinfo->scrny * 2);
	Sheet::set_buffer(sheet_back, buf_back, sysinfo->scrnx, sysinfo->scrny, -1); /* FȂ */
	//Graphics::init(buf_back, sysinfo->scrnx, sysinfo->scrny);
	Gui::init(fat, memory_manager, buf_back, sysinfo->scrnx, sysinfo->scrny);

	/* sheet_console */
	key_win = open_console(sheet_manager, memtotal);

	/* sheet_mouse */
	sheet_mouse = SheetManager::allocate(sheet_manager);
	Sheet::set_buffer(sheet_mouse, buf_mouse, 11, 17, 99);
	MouseCursor::init(buf_mouse, 99);
	mx = (sysinfo->scrnx - 16) / 2; /* ʒɂȂ悤ɍWvZ */
	my = (sysinfo->scrny - 28 - 16) / 2;

	Sheet::slide(sheet_back,  0,  0);
	Sheet::slide(key_win,   32, 4);
	Sheet::slide(sheet_mouse, mx, my);
	Sheet::up_down(sheet_back,  0);
	Sheet::up_down(key_win,   1);
	Sheet::up_down(sheet_mouse, 2);
	keywin_on(key_win);

	/* ŏɃL[{[hԂƂ̐HႢȂ悤ɁAݒ肵ĂƂɂ */
	Queue::push(&keycmd, KEYCMD_LED);
	Queue::push(&keycmd, key_leds);

	/* nihongo.fnt̓ǂݍ */
	finfo = File::search("nihongo.fnt", (FileInfo *) (ADR_DISKIMG + 0x002600), 224);
	if (finfo != 0) {
		i = finfo->size;
		nihongo = File::load_file2(finfo->clustno, &i, fat);
	} else {
		nihongo = (unsigned char *) MemoryManager::allocate_4k(memory_manager, 16 * 256 + 32 * 94 * 47);
		for (i = 0; i < 16 * 256; i++) {
			nihongo[i] = hankaku[i]; /* tHgȂ̂ŔpRs[ */
		}
		for (i = 16 * 256; i < 16 * 256 + 32 * 94 * 47; i++) {
			nihongo[i] = 0xff; /* tHgȂ̂őSp0xffŖߐs */
		}
	}
	*((int *) 0x0fe8) = (int) nihongo;
	MemoryManager::deallocate_4k(memory_manager, (int) fat, 4 * 2880);

	for (;;) {
		if (Queue::status(&keycmd) > 0 && keycmd_wait < 0) {
			/* L[{[hRg[ɑf[^΁A */
			keycmd_wait = Queue::pop(&keycmd);
			Keyboard::sendready();
			io_out8(PORT_KEYDAT, keycmd_wait);
		}
		io_cli();
		if (Queue::status(&queue) == 0) {
			/* FIFOۂɂȂ̂ŁAۗĂ`悪Ύs */
			if (new_mx >= 0) {
				io_sti();
				Sheet::slide(sheet_mouse, new_mx, new_my);
				new_mx = -1;
			} else if (new_wx != 0x7fffffff) {
				io_sti();
				Sheet::slide(sheet, new_wx, new_wy);
				new_wx = 0x7fffffff;
			} else {
				Task::sleep(task_a);
				io_sti();
			}
		} else {
			i = Queue::pop(&queue);
			io_sti();
			if (key_win != 0 && key_win->flags == 0) {	/* EBhEꂽ */
				if (sheet_manager->top == 1) {	/* }EXƔwiȂ */
					key_win = 0;
				} else {
					key_win = sheet_manager->sheets[sheet_manager->top - 1];
					keywin_on(key_win);
				}
			}
			if (256 <= i && i <= 511) { /* L[{[hf[^ */
				if (i < 0x80 + 256) { /* L[R[h𕶎R[hɕϊ */
					if (key_shift == 0) {
						s[0] = keytable0[i - 256];
					} else {
						s[0] = keytable1[i - 256];
					}
				} else {
					s[0] = 0;
				}
				if ('A' <= s[0] && s[0] <= 'Z') {	/* ͕At@xbg */
					if (((key_leds & 4) == 0 && key_shift == 0) ||
							((key_leds & 4) != 0 && key_shift != 0)) {
						s[0] += 0x20;	/* 啶ɕϊ */
					}
				}
				if (s[0] != 0 && key_win != 0) { /* ʏ핶AobNXy[XAEnter */
					Queue::push(&key_win->task->queue, s[0] + 256);
				}
				if (i == 256 + 0x0f && key_win != 0) {	/* Tab */
					keywin_off(key_win);
					j = key_win->height - 1;
					if (j == 0) {
						j = sheet_manager->top - 1;
					}
					key_win = sheet_manager->sheets[j];
					keywin_on(key_win);
				}
				if (i == 256 + 0x2a) {	/* Vtg ON */
					key_shift |= 1;
				}
				if (i == 256 + 0x36) {	/* EVtg ON */
					key_shift |= 2;
				}
				if (i == 256 + 0xaa) {	/* Vtg OFF */
					key_shift &= ~1;
				}
				if (i == 256 + 0xb6) {	/* EVtg OFF */
					key_shift &= ~2;
				}
				if (i == 256 + 0x3a) {	/* CapsLock */
					key_leds ^= 4;
					Queue::push(&keycmd, KEYCMD_LED);
					Queue::push(&keycmd, key_leds);
				}
				if (i == 256 + 0x45) {	/* NumLock */
					key_leds ^= 2;
					Queue::push(&keycmd, KEYCMD_LED);
					Queue::push(&keycmd, key_leds);
				}
				if (i == 256 + 0x46) {	/* ScrollLock */
					key_leds ^= 1;
					Queue::push(&keycmd, KEYCMD_LED);
					Queue::push(&keycmd, key_leds);
				}
				if (i == 256 + 0x3b && key_shift != 0 && key_win != 0) {	/* Shift+F1 */
					task = key_win->task;
					if (task != 0 && task->tss.ss0 != 0) {
						Console::put_str0(task->console, "\nBreak(key) :\n");
						io_cli();	/* IɃ^XNςƍ邩 */
						task->tss.eax = (int) &(task->tss.esp0);
						task->tss.eip = (int) asm_end_app;
						io_sti();
						Task::run(task, -1, 0);	/* Imɂ点邽߂ɁAQĂN */
					}
				}
				if (i == 256 + 0x3c && key_shift != 0) {	/* Shift+F2 */
					/* VR\[͑IԂɂîقe؂ˁHj */
					if (key_win != 0) {
						keywin_off(key_win);
					}
					key_win = open_console(sheet_manager, memtotal);
					Sheet::slide(key_win, 32, 4);
					Sheet::up_down(key_win, sheet_manager->top);
					keywin_on(key_win);
				}
				if (i == 256 + 0x57) {	/* F11 */
					Sheet::up_down(sheet_manager->sheets[1], sheet_manager->top - 1);
				}
				if (i == 256 + 0xfa) {	/* L[{[hf[^𖳎Ɏ󂯎 */
					keycmd_wait = -1;
				}
				if (i == 256 + 0xfe) {	/* L[{[hf[^𖳎Ɏ󂯎Ȃ */
					Keyboard::sendready();
					io_out8(PORT_KEYDAT, keycmd_wait);
				}
			} else if (512 <= i && i <= 767) { /* }EXf[^ */
				if (Mouse::decode(&mouse, i - 512) != 0) {
					/* }EXJ[\̈ړ */
					mx += mouse.x;
					my += mouse.y;
					if (mx < 0) {
						mx = 0;
					}
					if (my < 0) {
						my = 0;
					}
					if (mx > sysinfo->scrnx - 1) {
						mx = sysinfo->scrnx - 1;
					}
					if (my > sysinfo->scrny - 1) {
						my = sysinfo->scrny - 1;
					}
					new_mx = mx;
					new_my = my;
					if ((mouse.btn & 0x01) != 0) {
						/* {^Ă */
						if (mmx < 0) {
							/* ʏ탂[h̏ꍇ */
							/* ̉珇ԂɃ}EXwĂ鉺T */
							for (j = sheet_manager->top - 1; j > 0; j--) {
								sheet = sheet_manager->sheets[j];
								x = mx - sheet->vx0;
								y = my - sheet->vy0;
								if (0 <= x && x < sheet->bxsize && 0 <= y && y < sheet->bysize) {
									if (sheet->buf[y * sheet->bxsize + x] != sheet->col_inv) {
										Sheet::up_down(sheet, sheet_manager->top - 1);
										if (sheet != key_win) {
											keywin_off(key_win);
											key_win = sheet;
											keywin_on(key_win);
										}
										if (3 <= x && x < sheet->bxsize - 3 && 3 <= y && y < 21) {
											mmx = mx;	/* EBhEړ[h */
											mmy = my;
											mmx2 = sheet->vx0;
											new_wy = sheet->vy0;
										}
										if (sheet->bxsize - 21 <= x && x < sheet->bxsize - 5 && 5 <= y && y < 19) {
											/* u~v{^NbN */
											if ((sheet->flags & 0x10) != 0) {		/* AvEBhEH */
												task = sheet->task;
												Console::put_str0(task->console, "\nBreak(mouse) :\n");
												io_cli();	/* IɃ^XNςƍ邩 */
												task->tss.eax = (int) &(task->tss.esp0);
												task->tss.eip = (int) asm_end_app;
												io_sti();
												Task::run(task, -1, 0);
											} else {	/* R\[ */
												task = sheet->task;
												Sheet::up_down(sheet, -1); /* Ƃ肠\ɂĂ */
												keywin_off(key_win);
												key_win = sheet_manager->sheets[sheet_manager->top - 1];
												keywin_on(key_win);
												io_cli();
												Queue::push(&task->queue, 4);
												io_sti();
											}
										}
										break;
									}
								}
							}
						} else {
							/* EBhEړ[h̏ꍇ */
							x = mx - mmx;	/* }EẌړʂvZ */
							y = my - mmy;
							new_wx = (mmx2 + x + 2) & ~3;
							new_wy = new_wy + y;
							mmy = my;	/* ړ̍WɍXV */
						}
					} else {
						/* {^ĂȂ */
						mmx = -1;	/* ʏ탂[h */
						if (new_wx != 0x7fffffff) {
							Sheet::slide(sheet, new_wx, new_wy);	/* xm肳 */
							new_wx = 0x7fffffff;
						}
					}
				}
			} else if (768 <= i && i <= 1023) {	/* R\[I */
				close_console(sheet_manager->sheets0 + (i - 768));
			} else if (1024 <= i && i <= 2023) {
				close_console_task(task_manager->tasks0 + (i - 1024));
			} else if (2024 <= i && i <= 2279) {	/* R\[ */
				sheet2 = sheet_manager->sheets0 + (i - 2024);
				MemoryManager::deallocate_4k(memory_manager, (int) sheet2->buf, 256 * 165);
				Sheet::deallocate(sheet2);
			}
		}
	}
}

void keywin_off(Sheet *key_win)
{
	//Window::change_wtitle(key_win, 0);
	Gui::drawTitle(key_win, false);
	if ((key_win->flags & 0x20) != 0) {
		Queue::push(&key_win->task->queue, 3); /* R\[̃J[\OFF */
	}
	return;
}

void keywin_on(Sheet *key_win)
{
	//Window::change_wtitle(key_win, 1);
	Gui::drawTitle(key_win, true);
	if ((key_win->flags & 0x20) != 0) {
		Queue::push(&key_win->task->queue, 2); /* R\[̃J[\ON */
	}
	return;
}

Task *open_console_task(Sheet *sheet, unsigned int memtotal)
{
	MemoryManager *memory_manager = (MemoryManager *) MEMMAN_ADDR;
	Task *task = Task::allocate();
	int *console_queue = (int *) MemoryManager::allocate_4k(memory_manager, 128 * 4);
	task->console_stack = MemoryManager::allocate_4k(memory_manager, 64 * 1024);
	task->tss.esp = task->console_stack + 64 * 1024 - 12;
	task->tss.eip = (int) &console_task;
	task->tss.es = 1 * 8;
	task->tss.cs = 2 * 8;
	task->tss.ss = 1 * 8;
	task->tss.ds = 1 * 8;
	task->tss.fs = 1 * 8;
	task->tss.gs = 1 * 8;
	*((int *) (task->tss.esp + 4)) = (int) sheet;
	*((int *) (task->tss.esp + 8)) = memtotal;
	Task::run(task, 2, 2); /* level=2, priority=2 */
	Queue::init(&task->queue, 128, console_queue, task);
	return task;
}

Sheet *open_console(SheetManager *sheet_manager, unsigned int memtotal)
{
	MemoryManager *memory_manager = (MemoryManager *) MEMMAN_ADDR;
	Sheet *sheet = SheetManager::allocate(sheet_manager);
	unsigned short *buf = (unsigned short *) MemoryManager::allocate_4k(memory_manager, 256 * 165 * 2);
	Sheet::set_buffer(sheet, buf, 256, 165, -1); /* FȂ */
	//Window::make_window(buf, 256, 165, "console", 0);
	//Window::make_textbox(sheet, 8, 28, 240, 128, COL8_000000);
	Gui::drawFrame(sheet, "console");
	sheet->task = open_console_task(sheet, memtotal);
	sheet->flags |= 0x20;	/* J[\ */
	return sheet;
}

void close_console_task(Task *task)
{
	MemoryManager *memory_manager = (MemoryManager *) MEMMAN_ADDR;
	Task::sleep(task);
	MemoryManager::deallocate_4k(memory_manager, task->console_stack, 64 * 1024);
	MemoryManager::deallocate_4k(memory_manager, (int) task->queue.buf, 128 * 4);
	io_cli();
	task->flags = 0; /* task_free(task); ̑ */
	if (task_manager->task_fpu == task) {
		task_manager->task_fpu = 0;
	}
	io_sti();
	return;
}

void close_console(Sheet *sheet)
{
	MemoryManager *memory_manager = (MemoryManager *) MEMMAN_ADDR;
	Task *task = sheet->task;
	MemoryManager::deallocate_4k(memory_manager, (int) sheet->buf, 256 * 165);
	Sheet::deallocate(sheet);
	close_console_task(task);
	return;
}
