#include <stdio.h>
#include <stdlib.h>
#include "List.h"

char* ebp;
char* esp;
int gc_count;

typedef struct
{
    bool  marked;
    void* address;
}
ListEntry;

List<ListEntry*>* entry_list;

void gc_mark()
{
    asm volatile("movl %%esp, %0" : "=g"(esp));
    int start = (int) esp;
    int end   = (int) ebp;
    printf("\t==== marking start !!!! ====\n");
    printf("\t\tesp = 0x%08x\n", (int*) start);
    printf("\t\tebp = 0x%08x\n", (int*) end);
    for (int i = 0; i < end - start; i++)
    {
        int p = *((int *) &esp[i]);
        int J = entry_list->size();
        for (int j = 0; j < J; j++)
        {
            ListEntry* entry = entry_list->get(j);
            if (entry->marked == false && p == (int) entry->address)
            {
                printf("\t\tmarked 0x%08x = 0x%08x\n", &esp[i], p);
                entry->marked = true;
            }
        }
    }
    printf("\t==== marking end !!!! ====\n");
}

void gc_sweep()
{
    printf("\t==== sweeping start !!!! ====\n");
    for (int j = 0; j < entry_list->size(); j++)
    {
        ListEntry* entry = entry_list->get(j);
        if (entry->marked == false)
        {
            printf("\t\tsweeped 0x%08x\n", (int) entry->address);
            entry_list->removeAt(j);
            delete (int *) entry->address;
            free(entry);
            j--;
        }
    }
    printf("\t==== sweeping end !!!! ====\n");
}

void gc()
{
    gc_count = 0;
    gc_mark();
    gc_sweep();
}

void gc_init()
{
    asm volatile("movl %%ebp, %0" : "=g"(ebp));
    gc_count = 0;
    entry_list = (List<ListEntry*>*) malloc(sizeof(List<ListEntry*>));
}

void* operator new(unsigned int size)
{
    if (++gc_count % 4 == 0) gc();
    void* ret = malloc(size);
    printf("operator new(%d) = %p\n", size, ret);
    ListEntry* entry = (ListEntry *) malloc(sizeof(ListEntry));
    entry->marked  = false;
    entry->address = ret;
    entry_list->add(entry);
    return ret;
}
