#pragma once
#include "GVOImage.h"
#include "GVOConfig.h"



//!@brief qCOnlinevZX
class GVOGameProcess {
private:
	GVOGameProcess( const GVOGameProcess& );
	GVOGameProcess& operator=(const GVOGameProcess&);
private:
	HANDLE m_process;
	HWND m_window;

	GVOImage m_surveyCoordImage;
	POINT m_surveyCoord;
	DWORD m_timeStamp;

public:
	GVOGameProcess() :
		m_process( NULL ),
		m_window( NULL ),
		m_surveyCoord(),
		m_timeStamp()
	{
	}
	virtual ~GVOGameProcess()
	{
		clear();
	}

	HANDLE processHandle() const
	{
		return m_process;
	}

	//!@brief Q[vZXɊւ郊\[XB
	void clear();

	//!@brief ݒŏ
	void setConfig( const GVOConfig& config );

	//!@brief Q[ʂǂݎ
	//!@retval true ǂݎ萬B
	//!@retval false ǂݎ莸sB炭Q[NĂȂB
	bool updateState();

	//!@brief ʍW
	POINT surveyCoord() const
	{
		return m_surveyCoord;
	}

	//!@brief Q[ʓǂݎ萬̎
	DWORD timeStamp() const
	{
		return m_timeStamp;
	}

#ifndef NDEBUG
	//!@brief fobOp
	void setSurveyCoord( const POINT& worldCoord )
	{
		m_surveyCoord = worldCoord;
	}
	//!@brief fobOpʍW摜
	const GVOImage& surveyCoordImage() const
	{
		return m_surveyCoordImage;
	}
#endif

private:
	void grabImage( HDC hdc, const POINT& offset, const SIZE& size );
	bool updateSurveyCoord();
};

