#include "libwilmaops.h"

static void AccumulateShrinkedLine(int* destBuffer,
                            int destPixelStride, int destWidth,
                            byte* srcBuffer,
                            int srcOffset, int srcPixelStride,  
                            int origSrcWidth,
                            int numChannels,
                            int yStep, int srcScale, int destScale) {
	int subsampledWidth = (int)((long)destWidth * destWidth * srcScale / destScale);
	int srcWidth = subsampledWidth / destWidth;
	subsampledWidth = srcWidth * destWidth; // re-calculation.
	int xInSubSampledCoord = 0;
	int xInSrcCoord = 0;
	int xInDestCoord = 0;
	int xOfNextGridInDestCoord = srcWidth;
	int numSamplesInDestPixel = 0;
	int c;
	int destOffset = 0;

	while (xInSubSampledCoord < subsampledWidth) {
		int step = destWidth;
		int stepInDestCoord = 0;
		
		if (xInSubSampledCoord + destWidth < xOfNextGridInDestCoord) {
			// pass

		} else if (xInSubSampledCoord + destWidth == xOfNextGridInDestCoord) {
			stepInDestCoord = 1;
			xOfNextGridInDestCoord += srcWidth;

		} else {
			step = xOfNextGridInDestCoord - xInSubSampledCoord;
			stepInDestCoord = 1;
			xOfNextGridInDestCoord += srcWidth;
		}
		
		numSamplesInDestPixel += step;

		if (xInSrcCoord < origSrcWidth) {
			int weight = step * yStep;
			c = 0;
			for (c = 0; c < numChannels; c ++)
				 destBuffer[destOffset + c] += weight * srcBuffer[srcOffset + c];
		} else {
			for (c = 0; c < numChannels; c ++)
				destBuffer[destOffset + c] = (step + numSamplesInDestPixel) * destBuffer[destOffset + c] / numSamplesInDestPixel;
			// Src is out of buffer.
		}
		xInDestCoord += stepInDestCoord;
		if (stepInDestCoord > 0) {
			numSamplesInDestPixel = 0;
			destOffset += destPixelStride;
		}
		
		if (step < destWidth) {
			if (xInSrcCoord < origSrcWidth) {
				int weight = (destWidth - step) * yStep;
				for (c = 0; c < numChannels; c ++)
					destBuffer[destOffset + c] += weight * srcBuffer[srcOffset + c];
			} else {
				numSamplesInDestPixel += destWidth - step;
				// Src is out of buffer.
				for (c = 0; c < numChannels; c ++)
					destBuffer[destOffset + c] = 0;
			}
		}
		srcOffset += srcPixelStride;
		xInSubSampledCoord += destWidth;
		xInSrcCoord  += 1;				
	}
}

void CShrink(byte* destBuffer,
             int destOffset, int destRowStride, int destPixelStride, 
             int destWidth, int destHeight,
             byte* srcBuffer,
             int srcOffset, int srcRowStride, int srcPixelStride,  
             int origSrcWidth, int origSrcHeight,
             int numChannels, int srcScale, int destScale) {

	int intermediateBuffer[destWidth * numChannels];
	int subsampledWidth = (int)((long)destWidth * destWidth * srcScale / destScale);
	int subsampledHeight = (int)((long)destHeight * destHeight * srcScale / destScale);
	int srcWidth = subsampledWidth / destWidth;
	subsampledWidth = srcWidth * destWidth; // re-calculation.
	int srcHeight = subsampledHeight / destHeight;
	subsampledHeight = srcHeight * destHeight; // re-calculation.
	int yInSubSampledCoord = 0;
	int yInSrcCoord = 0;
	int yInDestCoord = 0;
	int yOfNextGridInDestCoord = srcHeight;
	int accumulatedSamples = srcHeight * srcWidth;
	
	memset(intermediateBuffer, 0, sizeof(int) * numChannels * destWidth);

//			Console.WriteLine("destWidth ="+destWidth+", destHeight ="+destHeight);
//			Console.WriteLine("srcWidth ="+srcWidth+", srcHeight ="+srcHeight);
	
	while (yInSubSampledCoord < subsampledHeight) {
		int step = destHeight;
		int stepInDestCoord = 0;
		
		if (yInSubSampledCoord + destHeight < yOfNextGridInDestCoord) {
			// pass

		} else if (yInSubSampledCoord + destHeight == yOfNextGridInDestCoord) {
			stepInDestCoord = 1;
			yOfNextGridInDestCoord += srcHeight;

		} else {
			step = yOfNextGridInDestCoord - yInSubSampledCoord;
			stepInDestCoord = 1;
			yOfNextGridInDestCoord += srcHeight;
		}

//					Console.WriteLine("dest="+yInDestCoord+",src="+yInSrcCoord+",subsampled="+yInSubSampledCoord+",srcOffset="+srcOffset+",srcRowStride="+srcRowStride);
		if (yInSrcCoord < origSrcHeight) {
			AccumulateShrinkedLine(intermediateBuffer, numChannels, destWidth,
			                       srcBuffer, srcOffset, srcPixelStride, origSrcWidth,
			                       numChannels, step, srcScale, destScale);
		} else {
//					Console.WriteLine("y in src="+yInSrcCoord+",height="+srcHeight);
			accumulatedSamples -= srcHeight;
		}

		if (stepInDestCoord > 0) {
			if (accumulatedSamples > 0) {
				int i, c;
				for (i = 0; i < destWidth; i ++) {
					for (c = 0; c < numChannels; c++)
						destBuffer[destOffset+c] = (byte)(intermediateBuffer[i * numChannels + c] / accumulatedSamples);
					destOffset += destPixelStride;
				}
			} else {
//						Console.WriteLine("clear destBuffer["+destOffset+"-"+(destOffset+destWidth*numChannels)+"]");
				memset(destBuffer + destOffset, 0, sizeof(byte) * numChannels * destWidth);
			}
			destOffset += destRowStride - destWidth * destPixelStride;
			memset(intermediateBuffer, 0, sizeof(int) * numChannels * destWidth);
			yInDestCoord += stepInDestCoord;
		}
		
		if (step < destHeight) {
			if (yInSrcCoord < origSrcHeight) {
				AccumulateShrinkedLine(intermediateBuffer, numChannels, destWidth,
				                       srcBuffer, srcOffset, srcPixelStride, origSrcWidth,
				                       numChannels, destHeight - step, srcScale, destScale);
			} else if (stepInDestCoord == 0) { // When stepInDestCoord > 0, intermediateBuffer is 
				                               // already cleared.
//						Console.WriteLine("clear destBuffer["+destOffset+"-"+(destOffset+destWidth*numChannels)+"]");
				memset(intermediateBuffer, 0, sizeof(int) * numChannels * destWidth);
			} else {
//						Console.WriteLine("Do nothing");
				// pass
			}
		}
		yInSubSampledCoord += destHeight;
		srcOffset += srcRowStride;
		yInSrcCoord  += 1;
	}
}

