// Encoder.cs created with MonoDevelop
// User: tarai at 23:39 2008/06/27
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.IO;
using Holo.Image;
using System.Collections;
using System.Xml;
using System.Xml.Serialization;

namespace Holo.Codec.TRS {
	
	
	public class TRSEncoder : TRSCodecBase, Holo.Codec.ISurfaceEncoder {
		private ArrayList rasterClassArray;
		private ArrayList rasterDataArray;
		private ArrayList rasterArray;
		private int tiledWidth;

		/// <summary>
		/// Default constructor.
		/// </summary>
		public TRSEncoder() {
			rasterClassArray = new ArrayList();
			rasterDataArray = new ArrayList();
			rasterArray = new ArrayList();
		}

		/// <summary>
		/// Initialize state of the object.
		/// </summary>
		/// <param name="surface">
		/// A <see cref="ISurface"/>
		/// </param>
		private void Initialize(ISurface surface) {
			rasterClassArray.Clear();
			rasterDataArray.Clear();
			rasterArray.Clear();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="surface">
		/// A <see cref="ISurface"/>
		/// </param>
		/// <param name="stream">
		/// A <see cref="Stream"/>
		/// </param>
		/// <returns>
		/// A <see cref="System.Boolean"/>
		/// </returns>
		private bool WriteRasterClassTable(ISurface surface, Stream stream) {
			Surface surfaceClass = new Surface(surface);
			surfaceClass.RasterClasses.Classes = (RasterClass[])rasterClassArray.ToArray(typeof(RasterClass));

			surfaceClass.RasterClasses.Instances = new Raster[rasterDataArray.Count];
			int i = 0;
			foreach (RasterData data in rasterDataArray) {
				surfaceClass.RasterClasses.Instances[i++] = new Raster((RasterClass)rasterClassArray[data.ClassIndex], data);
			}
			
			surfaceClass.Mapping = (int[])rasterArray.ToArray(typeof(int));
			
			XmlSerializer serializer = new XmlSerializer(typeof(Surface));
			serializer.Serialize(stream, surfaceClass);
			return true;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="stream">
		/// A <see cref="Stream"/>
		/// </param>
		/// <returns>
		/// A <see cref="System.Boolean"/>
		/// </returns>
		private bool WriteRasterDataTable(Stream stream) {
			return true;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="stream">
		/// A <see cref="Stream"/>
		/// </param>
		/// <returns>
		/// A <see cref="System.Boolean"/>
		/// </returns>
		private bool WriteRasterMapTable(Stream stream) {
			return true;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="raster">
		/// A <see cref="IRaster"/>
		/// </param>
		/// <returns>
		/// A <see cref="System.Int32"/>
		/// </returns>
		private int RegisterRasterClass(IRaster raster) {
			RasterClass rasterClass = new RasterClass(raster);
			int index = rasterClassArray.IndexOf(rasterClass);
			if (index < 0) {
				index = rasterClassArray.Count;
				rasterClass.Index = index;
				rasterClassArray.Add(rasterClass);
			}
			
			return index;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="classIndex">
		/// A <see cref="System.Int32"/>
		/// </param>
		/// <param name="raster">
		/// A <see cref="IRaster"/>
		/// </param>
		/// <returns>
		/// A <see cref="System.Int32"/>
		/// </returns>
		private int RegisterRasterData(int classIndex, IRaster raster) {
			RasterData rasterData = new RasterData(classIndex, raster);
			int index = rasterDataArray.IndexOf(rasterData);
			if (index < 0) {
				index = rasterDataArray.Count;
				rasterDataArray.Add(rasterData);
			}
			
			return index;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="surface">
		/// A <see cref="ISurface"/>
		/// </param>
		/// <param name="stream">
		/// A <see cref="Stream"/>
		/// </param>
		/// <returns>
		/// A <see cref="System.Boolean"/>
		/// </returns>
		public bool Encode(ISurface surface, Stream stream) {
			Initialize(surface);

			ISurfaceIterator iter = surface.GetIteratorAt(surface.OffsetX, surface.OffsetY);
			tiledWidth = 0;
			bool firstLineScan = true;
			
			int classIndex;
			int rasterIndex;
			if (surface is Holo.Image.Tiled.TiledSurface) {
				System.Console.WriteLine("register default raster");
				classIndex = RegisterRasterClass(((Holo.Image.Tiled.TiledSurface)surface).DefaultRaster);
				rasterIndex = RegisterRasterData(classIndex, ((Holo.Image.Tiled.TiledSurface)surface).DefaultRaster);
			}
			
			for (;!iter.IsYEnded(); iter.ResetXAndAddY(iter.HeightOfRaster)) {
				for (;!iter.IsXEnded(); iter.AddX(iter.WidthOfRaster)) {
					classIndex = RegisterRasterClass(iter.Raster);
					rasterIndex = RegisterRasterData(classIndex, iter.Raster);
					
					rasterArray.Add(rasterIndex);
					if (firstLineScan)
						tiledWidth ++;
				}
				firstLineScan = false;
			}
			bool result = WriteRasterClassTable(surface, stream) &&
				WriteRasterDataTable(stream) &&
				WriteRasterMapTable(stream);
			
			Initialize(surface);
			return result;
		}
		
	}
}
