// /home/tarai/Projects/gsaw/StopWatch.cs created with MonoDevelop
// User: tarai at 18:21 2008/05/25
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Runtime.InteropServices;

namespace D {
	
	
	public class StopWatch {
		private long start;
		private long total;
		private long count;
		
//		[System.Security.SuppressUnmanagedCodeSecurity]
		[DllImport("/usr/local/lib/rdtsc.so")]
		private static extern System.Int64 rdtsc();
		
		public StopWatch() {
		}
		
		public void Start() {
			count ++;
			start = rdtsc();
		}
		
		public void Stop() {
			total += rdtsc() - start;
		}
		
		public long RunningTime {
			get { return rdtsc() - start; }
		}
		
		public long StartCount {
			get { return count; }
		}
		
		public long TotalTime {
			get { return total; }
		}
		
		public void Reset() {
			total = 0;
			start = 0;
			count = 0;
		}
	}
}
