// /home/tarai/Projects/gsaw/RotateOperation.cs created with MonoDevelop
// User: tarai at 22:16 2008/05/14
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Runtime.InteropServices;

namespace Holo.Operation {
	
	using Holo.Image;
	
	public class RotateOperation {
		
		protected double degree;
		protected long iSin, iCos;
		protected long rISin, rICos;
		const int SAMPLING_RATE_BITS = 10;
		const int SAMPLING_RATE = 1 << SAMPLING_RATE_BITS;
		
		private int destStartX;
		private int destStartY;
		private int destEndX;
		private int destEndY;
		
		public double Degree {
			get { return degree; }
			set { 
				degree = value; 
				iSin = (long)(Math.Sin(degree * Math.PI / 180) * SAMPLING_RATE);
				iCos = (long)(Math.Cos(degree * Math.PI / 180) * SAMPLING_RATE);
				rISin = (long)(Math.Sin(-degree * Math.PI / 180) * SAMPLING_RATE);
				rICos = (long)(Math.Cos(-degree * Math.PI / 180) * SAMPLING_RATE);
			}
		}

		public RotateOperation() {
			Degree = 0;
		}
		
		public int LastDestStartX {
			get {return destStartX >> SAMPLING_RATE_BITS; }
		}
		public int LastDestStartY {
			get {return destStartY >> SAMPLING_RATE_BITS; }
		}
		public int LastDestEndX {
			get {return (destEndX + SAMPLING_RATE - 1) >> SAMPLING_RATE_BITS; }
		}
		public int LastDestEndY {
			get {return (destEndY + SAMPLING_RATE - 1) >> SAMPLING_RATE_BITS; }
		}

		protected void RotateDecimalCoords(ref int x, ref int y, int originX, int originY) {
			int oldX = x;
			int oldY = y;
			x = ((int)((iCos * (oldX-originX) - iSin * (oldY-originY))>>SAMPLING_RATE_BITS) + originX);
			y = ((int)((iSin * (oldX-originX) + iCos * (oldY-originY))>>SAMPLING_RATE_BITS) + originY);
		}

		protected void RotateCoords(ref int x, ref int y, int originX, int originY) {
			x <<= SAMPLING_RATE_BITS;
			y <<= SAMPLING_RATE_BITS;
			RotateDecimalCoords(ref x, ref y, originX << SAMPLING_RATE_BITS, originY << SAMPLING_RATE_BITS);
			x >>= SAMPLING_RATE_BITS;
			y >>= SAMPLING_RATE_BITS;
		}

		protected void RotateDecimalCoordsReverse(ref int x, ref int y, int originX, int originY) {
			int oldX = x;
			int oldY = y;
			x = ((int)((rICos * (oldX-originX) - rISin * (oldY-originY))>>SAMPLING_RATE_BITS) + originX);
			y = ((int)((rISin * (oldX-originX) + rICos * (oldY-originY))>>SAMPLING_RATE_BITS) + originY);
		}

		protected void RotateCoordsReverse(ref int x, ref int y, int originX, int originY) {
			x <<= SAMPLING_RATE_BITS;
			y <<= SAMPLING_RATE_BITS;
			RotateDecimalCoordsReverse(ref x, ref y, originX << SAMPLING_RATE_BITS, originY << SAMPLING_RATE_BITS);
			x >>= SAMPLING_RATE_BITS;
			y >>= SAMPLING_RATE_BITS;
		}
		
#if USE_EXTERNAL_OPS
		[DllImport("libwilmaops.so")]
		static extern protected void CRotate(byte[] srcPixels, int srcRowStride, int srcPixelStride, int srcOffsetX, int srcOffsetY, int srcWidth, int srcHeight,
		                       int srcStartX, int srcStartY,
		                      int dxInXAxis, int dyInXAxis, int dxInYAxis, int dyInYAxis,
		                       int srcMinX, int srcMinY, int srcMaxX, int srcMaxY, 
		                       byte[] destPixels, int destRowStride, int destPixelStride, int destChannels,
		                       int destOriginX, int destOriginY,
		                       int destMinX, int destMinY, int destMaxX, int destMaxY,
		                       int destStartX, int destStartY, int destEndX, int destEndY);
#else
		static protected void Rotate(byte[] srcPixels, int srcRowStride, int srcPixelStride, int srcOffsetX, int srcOffsetY, int srcWidth, int srcHeight,
		                       int srcStartX, int srcStartY,
		                      int dxInXAxis, int dyInXAxis, int dxInYAxis, int dyInYAxis,
		                       int srcMinX, int srcMinY, int srcMaxX, int srcMaxY, 
		                       byte[] destPixels, int destRowStride, int destPixelStride, int destChannels,
		                       int destOriginX, int destOriginY,
		                       int destMinX, int destMinY, int destMaxX, int destMaxY,
		                       int destStartX, int destStartY, int destEndX, int destEndY) {
//			temporary disabled.
/*			
			int subsampledX, subsampledY;
			int xInDestCoords, yInDestCoords;
			int xInSrcCoords, yInSrcCoords;
			
//			Console.WriteLine("max:src={0},{1},{2},{3}:center={4},{5},size={6},{7}", srcMinX, srcMinY, srcMaxX, srcMaxY, srcOriginX, srcOriginY, srcWidth, srcHeight);
//			Console.WriteLine("max:dest={0},{1},{2},{3}:center={4},{5}", destMinX, destMinY, destMaxX, destMaxY, destOriginX, destOriginY, srcWidth, srcHeight);
//			Console.WriteLine("range: src={0},{1}- , dest={2},{3}-{4},{5}", srcStartX, srcStartY, destStartX, destStartY, destEndX, destEndY);
			
			subsampledX = srcStartX;
			subsampledY = srcStartY;
//			subsampledX = srcStartX << SAMPLING_RATE_BITS;
//			subsampledY = srcStartY << SAMPLING_RATE_BITS;

			for (yInDestCoords = destStartY; yInDestCoords < destEndY; yInDestCoords++) {
				int lineSubsampledX = subsampledX;
				int lineSubsampledY = subsampledY;
//				Console.WriteLine("dest:y={0}, src={1},{2}", yInDestCoords, lineSubsampledX >> SAMPLING_RATE_BITS, lineSubsampledY >> SAMPLING_RATE_BITS);
				for (xInDestCoords = destStartX; xInDestCoords < destEndX; xInDestCoords++) {
					xInSrcCoords = lineSubsampledX >> SAMPLING_RATE_BITS;
					yInSrcCoords = lineSubsampledY >> SAMPLING_RATE_BITS;
					
					if (lineSubsampledX >= destMinX  &&  lineSubsampledX < destMaxX  &&  
					    lineSubsampledX >= destMinY  &&  lineSubsampledX < destMaxY) {
						if (lineSubsampledX >= srcMinX  &&  lineSubsampledX < srcMaxX  &&  
						    lineSubsampledX >= srcMinY  &&  lineSubsampledX < srcMaxY) {
	//						Console.WriteLine("dest={0},{1}: src={2},{3}", xInDestCoords, yInDestCoords, lineSubsampledX >> SAMPLING_RATE_BITS, lineSubsampledY >> SAMPLING_RATE_BITS);
							int c;
							int prevX = xInSrcCoords - srcOffsetX; 
							int nextX = (xInSrcCoords == srcMaxX - 1 ? xInSrcCoords : xInSrcCoords + 1) - srcOffsetX;
							int prevY = yInSrcCoords  - srcOffsetY;
							int nextY = (yInSrcCoords == srcMaxY - 1 ? yInSrcCoords : yInSrcCoords + 1) - srcOffsetY;
							int xWeight2 = lineSubsampledX & (SAMPLING_RATE - 1);
							int xWeight1 = SAMPLING_RATE - 1 - xWeight2;
							int yWeight2 = lineSubsampledY & (SAMPLING_RATE - 1);
							int yWeight1 = SAMPLING_RATE - 1 - yWeight2;
							for (c = 0; c < destChannels; c ++) {
								int topColor, bottomColor;
								try {
								topColor = srcPixels[srcRowStride * prevY + srcPixelStride * prevX + c] * xWeight1 + 
									srcPixels[srcRowStride * prevY + srcPixelStride * nextX + c] * xWeight2;
								} catch (Exception e) {
									Console.WriteLine("top:({0}-{1}),{2}, MAX={3},{4}", prevX, nextX, prevY, srcMaxX, srcMaxY);
									throw e;
								}
								try {
								bottomColor = srcPixels[srcRowStride * nextY + srcPixelStride * prevX + c] * xWeight1 + 
									srcPixels[srcRowStride * nextY + srcPixelStride * nextX + c] * xWeight2;
								} catch (Exception e) {
									Console.WriteLine("bottom:({0}-{1}),{2}, BOUNDS={3},{4}-{5},{6}, offset={7},{8}", prevX, nextX, nextY, srcMinX, srcMinY, srcMaxX, srcMaxY, srcOffsetX, srcOffsetY);
									throw e;
								}
								destPixels[destRowStride * yInDestCoords + destPixelStride * xInDestCoords + c] = (byte)((topColor * yWeight1 + bottomColor * yWeight2) / ((SAMPLING_RATE - 1)*(SAMPLING_RATE - 1)));
									
							}
						} else {
//							int c;
//							for (c = 0; c < destChannels; c ++)
//								destPixels[destRowStride * yInDestCoords + destPixelStride * xInDestCoords + c] = 0x80;
						}
					}
					lineSubsampledX += dxInXAxis;
					lineSubsampledY += dyInXAxis;
				}
//				Console.WriteLine("src={0},{1}", subsampledX >> SAMPLING_RATE_BITS, subsampledY >> SAMPLING_RATE_BITS);
				subsampledX += dxInYAxis;
				subsampledY += dyInYAxis;
			}
//			Console.WriteLine("end:src={0},{1}", subsampledX >> SAMPLING_RATE_BITS, subsampledY >> SAMPLING_RATE_BITS);
*/
		}
#endif

		public virtual void Apply(ISurface surface, int srcOriginX, int srcOriginY, int minX, int minY, int maxX, int maxY, int destOriginX, int destOriginY, ISurface dest) {
			try {
				try {
				D.StopWatches.RotateOperation_Apply.Start();
				} catch (Exception e) {
					Console.WriteLine(e);
				}
			if (minX >= maxX || minY >= maxY)
				return;
			
			int srcCenterX = ((maxX + minX)<<SAMPLING_RATE_BITS) / 2;
			int srcCenterY = ((maxY + minY)<<SAMPLING_RATE_BITS) / 2;
			int destCenterX = srcCenterX, destCenterY = srcCenterY;
			RotateDecimalCoords(ref destCenterX, ref destCenterY, srcOriginX<<SAMPLING_RATE_BITS, srcOriginY<<SAMPLING_RATE_BITS);

			ISurfaceIterator surfIter = surface.GetIteratorAt(srcOriginX, srcOriginY);
			surfIter.SetRange(surface.OffsetX, surface.OffsetY, surface.OffsetX + surface.Width, surface.OffsetY + surface.Height);
			ISurfaceIterator destIter = dest.GetIteratorAt(destOriginX, destOriginY);
			surfIter.SetRange(dest.OffsetX, dest.OffsetY, dest.OffsetX + dest.Width, dest.OffsetY + dest.Height);
			
			bool surfHasColor = surfIter.Raster.HasColorChannels;
			bool destHasColor = destIter.Raster.HasColorChannels;

			int surfChannels = surfIter.Raster.NumChannels;
			int destChannels = destIter.Raster.NumChannels;

			if (surfChannels != destChannels) {
				// TBD.
				Console.WriteLine("src channels != dest channels, not yet implemented.");
				return;
			}

			if (!surfHasColor && destHasColor) {
				// TBD.
				Console.WriteLine("src does not have color , not yet implemented.");
				return;
			}
			
			int topLeftX = (minX - srcOriginX) << SAMPLING_RATE_BITS;
			int topLeftY = (minY - srcOriginY) << SAMPLING_RATE_BITS;
			int topRightX = (maxX - srcOriginX) << SAMPLING_RATE_BITS;
			int topRightY = (minY - srcOriginY) << SAMPLING_RATE_BITS;
			int bottomLeftX = (minX - srcOriginX) << SAMPLING_RATE_BITS;
			int bottomLeftY = (maxY - srcOriginY) << SAMPLING_RATE_BITS;
			int bottomRightX = (maxX - srcOriginX) << SAMPLING_RATE_BITS;
			int bottomRightY = (maxY - srcOriginY) << SAMPLING_RATE_BITS;
			
//			int dx;
//			int dy;
//			dx = (int)Math.Sqrt((topRightX - topLeftX)*(topRightX - topLeftX)+(topRightY - topLeftY)*(topRightY - topLeftY));
//			dy = (int)Math.Sqrt((bottomLeftX - topLeftX)*(bottomLeftX - topLeftX)+(bottomLeftY - topLeftY)*(bottomLeftY - topLeftY));
//			Console.WriteLine("orig bounds:({0},{1}),({2},{3}),({4},{5}),({6},{7}) = ({8},{9})", topLeftX, topLeftY, topRightX, topRightY, bottomLeftX, bottomLeftY, bottomRightX, bottomRightY, dx, dy);

			RotateDecimalCoords(ref topLeftX, ref topLeftY, 0, 0);
			RotateDecimalCoords(ref topRightX, ref topRightY, 0, 0);
			RotateDecimalCoords(ref bottomLeftX, ref bottomLeftY, 0, 0);
			RotateDecimalCoords(ref bottomRightX, ref bottomRightY, 0, 0);

//			dx = (int)Math.Sqrt((topRightX - topLeftX)*(topRightX - topLeftX)+(topRightY - topLeftY)*(topRightY - topLeftY));
//			dy = (int)Math.Sqrt((bottomLeftX - topLeftX)*(bottomLeftX - topLeftX)+(bottomLeftY - topLeftY)*(bottomLeftY - topLeftY));
//			Console.WriteLine("->({0},{1}),({2},{3}),({4},{5}),({6},{7}) = ({8}, {9})", topLeftX, topLeftY, topRightX, topRightY, bottomLeftX, bottomLeftY, bottomRightX, bottomRightY, dx, dy);
			
			int destMinX = Math.Min(topLeftX, Math.Min(topRightX, Math.Min(bottomLeftX, bottomRightX)));
			int destMaxX = Math.Max(topLeftX, Math.Max(topRightX, Math.Max(bottomLeftX, bottomRightX)));
			int destMinY = Math.Min(topLeftY, Math.Min(topRightY, Math.Min(bottomLeftY, bottomRightY)));
			int destMaxY = Math.Max(topLeftY, Math.Max(topRightY, Math.Max(bottomLeftY, bottomRightY)));
			
//			Console.WriteLine("dest bouds:({0},{1})-({2},{3}) = ({4},{5})", destMinX, destMinY, destMaxX, destMaxY, destMaxX - destMinX, destMaxY - destMinY);

			destStartX = destMinX + (destOriginX << SAMPLING_RATE_BITS);
			destStartY = destMinY + (destOriginY << SAMPLING_RATE_BITS);
			destEndX = destMaxX + (destOriginX << SAMPLING_RATE_BITS);
			destEndY = destMaxY + (destOriginY << SAMPLING_RATE_BITS);
			
			int srcStartX = destMinX;
			int srcStartY = destMinY;
			int dxInXAxis = (int)iCos;
			int dyInXAxis = (int)-iSin;

			int dxInYAxis = (int)iSin;
			int dyInYAxis = (int)iCos;
			
			
			RotateDecimalCoordsReverse(ref srcStartX, ref srcStartY, 0, 0);
			srcStartX += srcOriginX << SAMPLING_RATE_BITS;
			srcStartY += srcOriginY << SAMPLING_RATE_BITS;
//			Console.Write("src:{0},{1}", srcStartX, srcStartY);
//			Console.WriteLine("={0},{1}", srcStartX>>SAMPLING_RATE_BITS, srcStartY>>SAMPLING_RATE_BITS);
//			Console.Write("dest:{0},{1}-{2},{3}", destStartX, destStartY, destEndX, destEndY);
//			Console.WriteLine("={0},{1}-{2},{3}", destStartX>>SAMPLING_RATE_BITS, destStartY>>SAMPLING_RATE_BITS, destEndX>>SAMPLING_RATE_BITS, destEndY>>SAMPLING_RATE_BITS);

#if USE_EXTERNAL_OPS
			CRotate(
#else
			Rotate(
#endif
			       surfIter.Raster.Buffer, surfIter.Raster.RowStride, surfIter.Raster.PixelStride, surface.OffsetX, surface.OffsetY, surface.Width, surface.Height,
			       srcStartX, srcStartY,
			       dxInXAxis, dyInXAxis, dxInYAxis, dyInYAxis,
			       minX << SAMPLING_RATE_BITS, minY << SAMPLING_RATE_BITS, (maxX << SAMPLING_RATE_BITS) + SAMPLING_RATE - 1, (maxY << SAMPLING_RATE_BITS) + SAMPLING_RATE - 1,
			       destIter.Raster.Buffer, destIter.Raster.RowStride, destIter.Raster.PixelStride, destChannels,
			       destCenterX - (dest.OffsetX << SAMPLING_RATE_BITS), destCenterY - (dest.OffsetY << SAMPLING_RATE_BITS),
			       0, 0, dest.Width << SAMPLING_RATE_BITS, dest.Height << SAMPLING_RATE_BITS,
			       destStartX - (dest.OffsetX << SAMPLING_RATE_BITS), destStartY - (dest.OffsetY<<SAMPLING_RATE_BITS), destEndX - (dest.OffsetX<<SAMPLING_RATE_BITS) + SAMPLING_RATE - 1, destEndY - (dest.OffsetY<<SAMPLING_RATE_BITS) + SAMPLING_RATE - 1);
			} finally {
				D.StopWatches.RotateOperation_Apply.Stop();
			}
		}
	}
}