// /home/tarai/Projects/gsaw/gsaw/OperationHistory.cs created with MonoDevelop
// User: tarai at 14:33 2008/05/03
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Collections;

namespace Lawrence.History {
	
	
	public class OperationHistory {
		private Stack undoHistory;
		private Stack redoHistory;
		
		public OperationHistory() {
			undoHistory = new Stack();
			redoHistory = new Stack();
		}
		
		public void Add(IUndoInfo info) {
//			Console.WriteLine("History.Add");
			redoHistory.Clear();
			undoHistory.Push(info);
		}
		
		public void Undo() {
//			Console.WriteLine("History.Undo");
			if (undoHistory.Count > 0) {
				IUndoInfo undoInfo = (IUndoInfo)undoHistory.Pop();
				IUndoInfo redoInfo = undoInfo.CreateReverseUndoInfo();
				redoHistory.Push(redoInfo);
				undoInfo.Undo();
			}
		}
		
		public void Redo() {
//			Console.WriteLine("History.Redo");
			if (redoHistory.Count > 0) {
				IUndoInfo redoInfo = (IUndoInfo)redoHistory.Pop();
				IUndoInfo undoInfo = redoInfo.CreateReverseUndoInfo();
				undoHistory.Push(undoInfo);
				redoInfo.Undo();
			}
		}
		
	}
}
