// /home/tarai/Projects/gsaw/gsaw/ClosedRegionExtractOperation.cs created with MonoDevelop
// User: tarai at 23:47 2008/06/02
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Collections;

namespace Holo.Operation {	
	using Holo.Image;
	using Holo.Operation.Processor;
	
	public class ClosedRegionExtractOperation {

//		public delegate void ExtractOperator(ISurfaceIterator surfIter, ISurfaceIterator auxIter, ISurfaceIterator maskIter, ISurfaceIterator destIter, int width, int height, double opacity);
//		private ExtractOperator opr;
		private double threshold;
		
		public double Threshold {
			get { return threshold; }
			set { threshold = value; }
		}
/*		
		public ExtractOperator Operator {
			get { return opr; }
			set { opr = value; }
		}
*/		
		public ClosedRegionExtractOperation() {
			threshold = 1.0;
		}
		
		private class HorizontalArea {
			public ISurfaceIterator Min;
			public ISurfaceIterator Max;
			public ISurfaceIterator DestMin;
			public ISurfaceIterator DestMax;
			
			public HorizontalArea(ISurfaceIterator src, ISurfaceIterator dest) {
				this.Min = src.Clone();
				this.Max = src.Clone();
				this.DestMin = dest.Clone();
				this.DestMax = dest.Clone();
			}

			public HorizontalArea(ISurfaceIterator min, ISurfaceIterator max, ISurfaceIterator destMin, ISurfaceIterator destMax) {
				this.Min = min;
				this.Max = max;
				this.DestMin = destMin;
				this.DestMax = destMax;
			}
			
			public HorizontalArea(HorizontalArea area) {
				Min = area.Min.Clone();
				Max = area.Max.Clone();
				DestMin = area.DestMin.Clone();
				DestMax = area.DestMax.Clone();
			}
			
			public void IncY() {
				Min.AddY(1);
				Max.AddY(1);
				DestMin.AddY(1);
				DestMax.AddY(1);
			}
			
			public void DecY() {
				Min.SubY(1);
				Max.SubY(1);
				DestMin.SubY(1);
				DestMax.SubY(1);
			}
			
			public void IncMaxX() {
				if (Max.Raster.HasAlpha || Max.Raster.HasColorChannels) {
					Max.AddX(1);
					DestMax.AddX(1);
				} else {
					int stride = Max.Raster.Width - Max.OffsetXInRaster;
					Max.AddX(stride);
					DestMax.AddX(stride);
				}
			}
			
			public void IncX() {
				int stride;
				try {
					while (Min.OffsetX < 0) {
						stride = -Min.OffsetX;
						Min.AddX(stride);
						DestMin.AddX(stride);
					}
					if (Min.Raster.HasAlpha || Min.Raster.HasColorChannels) {
						Min.AddX(1);
						DestMin.AddX(1);
					} else {
						stride = Min.Raster.Width - Min.OffsetXInRaster;
						Min.AddX(stride);
						DestMin.AddX(stride);
					}
					stride = Max.OffsetX - Min.OffsetX;
					if (stride < 0) {
						Max.AddX(-stride);
						DestMax.AddX(-stride);
					}
				} catch (Exception e) {
					Console.WriteLine("Error at: min=({0},{1})",Min.OffsetX, Min.OffsetY);
					throw e;
				}
			}
			
			public void DecMinX() {
				if (Min.Raster.HasAlpha || Min.Raster.HasColorChannels) {
					Min.SubX(1);
					DestMin.SubX(1);
				} else {
					int stride = Min.OffsetXInRaster + 1;
					Min.SubX(stride);
					DestMin.SubX(stride);
				}
			}
			
			public bool IsXBelowMin() {
				return Min.IsXBelowMin() || DestMin.IsXBelowMin();
			}
			
			public bool IsXEnded() {
				return Max.IsXEnded() || DestMax.IsXEnded();
			}
			
			public bool IsYBelowMin() {
				return Min.IsYBelowMin() || DestMin.IsYBelowMin();
			}
			
			public bool IsYEnded() {
				return Min.IsYEnded() || DestMin.IsYEnded();
			}
		}
		
		private int PixelDifference(byte[] color, int colorOffset, int numChannels,
		                            byte[] alpha, int alphaOffset,
		                            byte[] initialColor, int initialColorOffset,
		                            byte[] initialAlpha, int initialAlphaOffset) {

			if (initialAlpha != null && initialAlpha[initialAlphaOffset] == 0) {
				// Initial pixel is transparent. Return difference of alpha channel.
				return Math.Abs(alpha[alphaOffset] - initialAlpha[initialAlphaOffset]);
			} else if (initialColor != null) {
				// Initial pixel is opaque. Return maximum of difference of (R, G, b).
				int maxDiff = 0;
				for (int i = 0; i < numChannels; i ++) {
					try {
					int diff = Math.Abs(color[colorOffset + i] - initialColor[initialColorOffset + i]);
					if (diff > maxDiff)
						maxDiff = diff;
					} catch (IndexOutOfRangeException e) {
						Console.WriteLine("Error: Color={1},{2}+{0}, initialColor={3},{4}+{0}", i, color, colorOffset, initialColor, initialColorOffset);
						Console.WriteLine(e.ToString());
						throw e;
					}
				}
				return maxDiff;
			} else {
				// Error case.
				return 0;
			}
		}
		
		
		private bool ExtractRegionFromSurface(byte[] initialColor, int initialColorOffset, int numChannels,
		                                      byte[] initialAlpha, int initialAlphaOffset,
		                                      ISurface dest, HorizontalArea area) {
			bool hasRegion = false;
			int destAlphaOffset = -1;
			while (!area.IsXBelowMin()) {
				byte[] curColor, curAlpha;
				int curColorOffset, curAlphaOffset;
				
				
				area.Min.GetCurrentColor(out curColor, out curColorOffset);
				area.Min.GetCurrentAlpha(out curAlpha, out curAlphaOffset);
				int diff = 0;
				try {
				diff = PixelDifference(curColor, curColorOffset, numChannels,
				                           curAlpha, curAlphaOffset,
				                           initialColor, initialColorOffset,
				                           initialAlpha, initialAlphaOffset);
				} catch (Exception e) {
					Console.WriteLine("Error:At {0},{1}={2},{3}", area.Min.OffsetX, area.Min.OffsetY, area.Min.OffsetXInRaster,area.Min.OffsetYInRaster);
					Console.WriteLine("Error:Pixel={0},Row={1}",area.Min.Raster.PixelStride, area.Min.Raster.RowStride);
					Console.WriteLine("Error:{0}", e.ToString());
					throw e;
				}
				if (diff > threshold)
					break;

				dest.MakeRastersWriteable(area.DestMin.OffsetX - area.DestMin.OffsetXInRaster, 
				                          area.DestMin.OffsetY - area.DestMin.OffsetYInRaster,
				                          area.Min.Raster.Width, area.Min.Raster.Height);
				area.DestMin.UpdateRaster();
				destAlphaOffset = area.DestMin.Raster.NumChannels - 1;

				if (!area.Min.Raster.HasColorChannels && !area.Min.Raster.HasAlpha) {
					for (int i = -area.DestMin.OffsetXInRaster; 
					     i < area.DestMin.Raster.Width - area.DestMin.OffsetXInRaster; 
					     i ++) {
						try {
						area.DestMin.Raster.Buffer[area.DestMin.OffsetInBuffer + i + destAlphaOffset] = (byte)(255 - diff);
						} catch (Exception e) {
							Console.WriteLine("raster={0}", area.DestMin.Raster);
							Console.WriteLine("buffer={0}", area.DestMin.Raster.Buffer);
							throw e;
						}
					}
				} else {
					area.DestMin.Raster.Buffer[area.DestMin.OffsetInBuffer + destAlphaOffset] = (byte)(255 - diff);
				}
				hasRegion = true;
				area.DecMinX();
			}

			while (!area.IsXEnded()) {
				byte[] curColor, curAlpha;
				int curColorOffset, curAlphaOffset;

				
				area.Max.GetCurrentColor(out curColor, out curColorOffset);
				area.Max.GetCurrentAlpha(out curAlpha, out curAlphaOffset);
				int diff = 0;
				try {
				diff = PixelDifference(curColor, curColorOffset, numChannels,
				                           curAlpha, curAlphaOffset,
				                           initialColor, initialColorOffset,
				                           initialAlpha, initialAlphaOffset);
				} catch (Exception e) {
					Console.WriteLine("Error:At {0},{1}={2},{3}", area.Max.OffsetX, area.Max.OffsetY, area.Max.OffsetXInRaster,area.Max.OffsetYInRaster);
					Console.WriteLine("Error:Pixel={0},Row={1}",area.Min.Raster.PixelStride, area.Min.Raster.RowStride);
					Console.WriteLine("Error:{0}", e.ToString());
					throw e;
				}
				if (diff > threshold)
					break;
				
				dest.MakeRastersWriteable(area.DestMax.OffsetX - area.DestMax.OffsetXInRaster, 
				                          area.DestMax.OffsetY - area.DestMax.OffsetYInRaster,
				                          area.Max.Raster.Width, area.Max.Raster.Height);
				area.DestMax.UpdateRaster();
				destAlphaOffset = area.DestMax.Raster.NumChannels - 1;
				
				if (!area.Max.Raster.HasColorChannels && !area.Max.Raster.HasAlpha) {
					for (int i = -area.DestMax.OffsetXInRaster; 
					     i < area.DestMax.Raster.Width - area.DestMax.OffsetXInRaster; 
					     i ++) {
						area.DestMax.Raster.Buffer[area.DestMax.OffsetInBuffer + i + destAlphaOffset] = (byte)(255 - diff);
					}
				} else {
					area.DestMax.Raster.Buffer[area.DestMax.OffsetInBuffer + destAlphaOffset] = (byte)(255 - diff);
				}
				hasRegion = true;
				area.IncMaxX();
			}

//			if (hasRegion) {
//				Console.WriteLine("Search Min: y=[{1},{3}],x=[{0},{2}]", area.Min.OffsetX, area.Min.OffsetY, area.Max.OffsetX, area.Max.OffsetY);
//			}

			return hasRegion;
		}
		
		public virtual void Apply(ISurface surface, int initialX, int initialY, ISurface dest) {
			Queue areaList = new Queue();

			ISurfaceIterator initialSrc = surface.GetIteratorAt(initialX, initialY);
			ISurfaceIterator initialDest = dest.GetIteratorAt(initialX, initialY);
			initialSrc.SetRange(surface.OffsetX, surface.OffsetY, surface.OffsetX + surface.Width, surface.OffsetY + surface.Height);
			initialDest.SetRange(surface.OffsetX, surface.OffsetY, surface.OffsetX + surface.Width, surface.OffsetY + surface.Height);

			ISurfaceIterator initialMin = initialSrc.Clone();
			ISurfaceIterator initialMax = initialSrc.Clone();
			ISurfaceIterator initialDestMin = initialDest.Clone();
			ISurfaceIterator initialDestMax = initialDest.Clone();
			initialMin.SubX(1);
			initialDestMin.SubX(1);
			initialMax.AddX(1);
			initialDestMax.AddX(1);
			areaList.Enqueue(new HorizontalArea(initialMin,
			                                    initialMax,
			                                    initialDestMin,
			                                    initialDestMax ));
			byte[] initialColor = null;
			byte[] initialAlpha = null;
			int initialColorOffset = 0;
			int initialAlphaOffset = 0;
			
			initialSrc.GetCurrentColor(out initialColor, out initialColorOffset);
			initialSrc.GetCurrentAlpha(out initialAlpha, out initialAlphaOffset);
			
			// Initial values are not referenced directly in the following blocks.
			initialSrc = initialDest = null;
			initialMin = initialMax = initialDestMin = initialDestMax = null;

			while (areaList.Count > 0) {
				HorizontalArea area = (HorizontalArea)areaList.Dequeue();
				HorizontalArea curArea = new HorizontalArea(area.Min, area.DestMin);
				curArea.Min.AddX(1);
				curArea.Max.AddX(1);
				curArea.DestMin.AddX(1);
				curArea.DestMax.AddX(1);
//				Console.WriteLine("Search Range:{0}-{1},{2}", area.Min.OffsetX, area.Max.OffsetX, area.Min.OffsetY);

				surface.MakeRastersReadable(surface.OffsetX, area.Min.OffsetY, surface.Width, 1);
				int numChannels = area.Min.Raster.NumChannels - (area.Min.Raster.HasAlpha? 1: 0);
//				Console.WriteLine("NumChannels={0}:HasAlpha={1}", numChannels, area.Min.Raster.HasAlpha);

				while (curArea.Min.OffsetX < area.Max.OffsetX) {
//					Console.WriteLine("Search H-Range:{0}-{1},{2}", curArea.Min.OffsetX, curArea.Max.OffsetX, curArea.Min.OffsetY);

					
					// Check wether this pixel was visited before.
					byte[] curAlpha;
					int curAlphaOffset;
					
					if (curArea.DestMin.GetCurrentAlpha(out curAlpha, out curAlphaOffset) && curAlpha[curAlphaOffset] != 0) {
						curArea.IncX();
						continue;
					}

					// Check contiguous region started at 'curArea' position.
					if (ExtractRegionFromSurface(initialColor, initialColorOffset, numChannels, initialAlpha, initialAlphaOffset,
					                             dest, curArea)) {
						// Add lines above and below current line to search.
						HorizontalArea prevLineArea = new HorizontalArea(curArea);
						HorizontalArea nextLineArea = new HorizontalArea(curArea);
						
						prevLineArea.DecY();
						if (!prevLineArea.IsYBelowMin())
							areaList.Enqueue(prevLineArea);

						nextLineArea.IncY();
						if (!nextLineArea.IsYEnded())
							areaList.Enqueue(nextLineArea);

					}

					// Increment search area
					curArea.IncX();
					int diff;
					diff = curArea.Max.OffsetX - curArea.Min.OffsetX;
					if (diff > 0) {
						curArea.Min.AddX(diff);
						curArea.DestMin.AddX(diff);
					}
				}
			}
		}
		
	}
}