// /home/tarai/Projects/gsaw/gsaw/BrushTool.cs created with MonoDevelop
// User: tarai at 16:59 2008/04/29
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Collections;

namespace Lawrence.Tool {
	using Holo.Image;
	using Holo.Image.Generic;
	using Holo.Image.Tiled;
	using Holo.Operation;
	using Holo.Operation.Processor;
	using Lawrence.Common;
	
	public class BrushTool : IPaintTool {
		
		public delegate void UpdateCoordinateHandler(PaintContext context, ImageCoordinate coords);
		public delegate ISurface CreateDabHandler(PaintContext context, ImageCoordinate coords, BrushTool tool);
		private CompositeOperation apply;
		private UpdateCoordinateHandler updateCoordinate;
		private CreateDabHandler createDab;
		private double steppingDistance;
		private double currentDistance;
		private ImageCoordinate lastCoordinate;
		private History.GenericUndoInfo undoInfo;
		
		private bool overwriteMode;
		private TiledSurface originalSurface;
		private TiledSurface brushSurface;
		private CompositeOperation brushSurfaceApply;
		private IRasterFactory rasterFactory;
		private int updatedMinX, updatedMinY, updatedMaxX, updatedMaxY;
		
		private bool activated;
		
		public UpdateCoordinateHandler UpdateCoordinate {
			get { return updateCoordinate; }
			set { updateCoordinate = value; }
		}
		
		public CreateDabHandler CreateDab {
			get { return createDab; }
			set { createDab = value; }
		}
		
		public CompositeOperation Apply {
			get { return apply; }
			set { apply = value; }
		}
		
		public double SteppingDistance {
			get { return steppingDistance; }
			set {
				if (value == 0.0)
					return;
				steppingDistance = value; 
			}
		}
		
		public IRasterFactory RasterFactory {
			get { return rasterFactory; }
			set {
				if (value != null)
					rasterFactory = value;
			}
		}
		
		public bool OverWrite {
			get { return overwriteMode; }
			set { overwriteMode = value; }
		}
			
		public BrushTool() {
			steppingDistance = 1;
			byte[] primaryColor = {0, 0, 0};
			byte[] primaryAlpha = {0};
			rasterFactory = new CompactMonochromeRasterFactory(primaryColor, primaryAlpha);
			activated = false;
		}
		
		public void OnStartStroke(PaintContext context, ImageCoordinate initialCoords, int time) {
			if (activated)
				return;
			
			if (context.History != null) {
				undoInfo = new History.GenericUndoInfo(context);
				undoInfo.Attach();

				context.History.Add(undoInfo);
			}
			if (updateCoordinate != null)
				updateCoordinate(context, initialCoords);

			// context.ActiveLayer should be TiledSurface now!
			if (!overwriteMode) {
				TiledSurface activeSurface = (TiledSurface)context.ActiveLayer.Surface;
				originalSurface = new TiledSurface(activeSurface);
				if (brushSurface == null ||
				    brushSurface.OffsetX != activeSurface.OffsetX ||
				    brushSurface.OffsetY != activeSurface.OffsetY ||
				    brushSurface.Width != activeSurface.Width ||
				    brushSurface.Height != activeSurface.Height) {
					brushSurface = new TiledSurface(activeSurface.OffsetX, activeSurface.OffsetY, activeSurface.Width, activeSurface.Height, rasterFactory);
				} else {
					brushSurface.ClearRasters();
					brushSurface.RasterFactory = rasterFactory;
				}
				brushSurfaceApply = new BlendOperation();
				brushSurfaceApply.Operator = ((BlendOperation)brushSurfaceApply).Apply;
			}

			updatedMinX = context.ActiveLayer.Surface.Width;
			updatedMinY = context.ActiveLayer.Surface.Height; 
			updatedMaxX = updatedMaxY = -1; 
			PaintDab(context, initialCoords);
			if (!overwriteMode) {
				JobProcessor processor = context.ActiveImage.Processor;
				apply.Apply(originalSurface, brushSurface, null, updatedMinX, updatedMinY, updatedMaxX, updatedMaxY, context.ActiveLayer.Surface, processor);
				if (processor != null)
					processor.ProcessSync();
			}
			lastCoordinate = initialCoords;
			currentDistance = 0;
			activated = true;
		}

		
		public void OnUpdateStroke(PaintContext context, ImageCoordinate newCoords, int time) {
			if (!activated)
				return;
			
			try {
				D.StopWatches.BrushTool_OnUpdateStroke.Start();
			if (context.History != null && undoInfo == null)
				return;
			bool updateEnabled = context.ActiveImage.EnableRealtimeUpdate;
			context.ActiveImage.EnableRealtimeUpdate = false;			
			
			if (updateCoordinate != null)
				updateCoordinate(context, newCoords);
			Array path = MakePath(newCoords);
			if (path != null) {
				updatedMinX = context.ActiveLayer.Surface.Width;
				updatedMinY = context.ActiveLayer.Surface.Height; 
				updatedMaxX = updatedMaxY = -1; 
				foreach (ImageCoordinate coords in path) {
					PaintDab(context, coords);
				}
				if (!overwriteMode) {
					JobProcessor processor = context.ActiveImage.Processor;
					apply.Apply(originalSurface, brushSurface, null, updatedMinX, updatedMinY, updatedMaxX, updatedMaxY, context.ActiveLayer.Surface, processor);
					if (processor != null)
						processor.ProcessSync();
				}
			}
//			context.ActiveImage.Processor.ProcessSync();	
			context.ActiveImage.EnableRealtimeUpdate = updateEnabled;
			} finally {
				D.StopWatches.BrushTool_OnUpdateStroke.Stop();
			}
		}
		
		
		public void OnFinishStroke(PaintContext context, ImageCoordinate finalCoords, int time) {
			if (!activated)
				return;
			
			if (undoInfo != null) {
				undoInfo.Dettach();
				undoInfo = null;
			}
			if (originalSurface != null) {
				originalSurface.ClearRasters();
				originalSurface = null;
			}
			if (brushSurface != null) {
				brushSurface.ClearRasters();
			}
			activated = false;
			D.StopWatches.DumpAndReset();
		}
		
		virtual protected Array MakePath(ImageCoordinate newCoords) {
			double xdiff = (newCoords.X - lastCoordinate.X);
			double ydiff = (newCoords.Y - lastCoordinate.Y);
			double pressureDiff = newCoords.Pressure - lastCoordinate.Pressure;
			double xTiltDiff = newCoords.XTilt - lastCoordinate.XTilt;
			double yTiltDiff = newCoords.YTilt - lastCoordinate.YTilt;
			double distance = Math.Sqrt(xdiff * xdiff + ydiff * ydiff);			
			currentDistance += distance;

			ImageCoordinate coords = null;

			ArrayList coordinates = new ArrayList();
			double passedDistance = 0;
			double step = lastCoordinate.Pressure * steppingDistance;
			if (step < 1)
				step = 1;
			while (passedDistance + step < distance) {
				passedDistance += step;
				coords = new ImageCoordinate();
				coords.X = lastCoordinate.X + xdiff * passedDistance / distance;
				coords.Y = lastCoordinate.Y + ydiff * passedDistance / distance;
				coords.Pressure = lastCoordinate.Pressure + pressureDiff * passedDistance / distance;
				coords.XTilt = lastCoordinate.XTilt + xTiltDiff * passedDistance / distance;
				coords.YTilt = lastCoordinate.YTilt + yTiltDiff * passedDistance / distance;
				coordinates.Add(coords);
				step = coords.Pressure * steppingDistance;
				if (step < 1)
					step = 1;
			}
			if (coordinates.Count == 0)
				return null;
			currentDistance -= passedDistance;
			lastCoordinate = coords;
			return coordinates.ToArray();
		}
		
		public void PaintDab(PaintContext context, ImageCoordinate coords) {
			try {
				try {
				D.StopWatches.BrushTool_PaintDab.Start();
				} catch (Exception e) {
					Console.WriteLine(e);
				}
			if (CreateDab != null && apply != null) {
				ISurface dab = null; 
				try {
					D.StopWatches.BrushTool_CreateDab.Start();
				dab = CreateDab(context, coords, this);
					} catch (Exception e) {
						Console.WriteLine(e);
					} finally {
						D.StopWatches.BrushTool_CreateDab.Stop();
					}
				if (overwriteMode) {
					apply.Apply(context.ActiveLayer.Surface, dab, null, context.ActiveLayer.Surface);
				} else {
					JobProcessor processor = context.ActiveImage.Processor;
//					JobProcessor processor = null;
					brushSurfaceApply.Opacity = coords.Pressure * coords.Pressure;
					brushSurfaceApply.Apply(brushSurface, dab, null, brushSurface, processor);
					if (dab.OffsetX < updatedMinX)
						updatedMinX = dab.OffsetX;
					if (dab.OffsetY < updatedMinY)
						updatedMinY = dab.OffsetY;
					if (dab.OffsetX + dab.Width > updatedMaxX)
						updatedMaxX = dab.OffsetX + dab.Width;
					if (dab.OffsetY + dab.Height > updatedMaxY)
						updatedMaxY = dab.OffsetY + dab.Height;
					if (processor != null)
						processor.ProcessSync();
				}
			}
			} finally {
				D.StopWatches.BrushTool_PaintDab.Stop();
			}
		}
	}
}
