// /home/tarai/Projects/gsaw/gsaw/BlendOperation.cs created with MonoDevelop
// User: tarai at 19:43 2008/04/29
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Operation {
	using Holo.Image;
	
	public class BasicOperation : CompositeOperation {
		
		protected class TripleIterator {
			public byte[] src1Pixels;
			public byte[] src2Pixels;
			public byte[] destPixels;
			public int src1Offset;
			public int src2Offset;
			public int destOffset;
			public int src1RowStride;
			public int src2RowStride;
			public int destRowStride;
			public int src1PixelStride;
			public int src2PixelStride;
			public int destPixelStride;
			public int width;
			
			public TripleIterator(ISurfaceIterator src1Iter, ISurfaceIterator src2Iter, ISurfaceIterator destIter, int width) {
				src1Pixels = src1Iter.Raster.Buffer;
				src1RowStride = src1Iter.Raster.RowStride;
				src1PixelStride = src1Iter.Raster.PixelStride;
				src1Offset = src1Iter.OffsetYInRaster * src1RowStride + 
					src1Iter.OffsetXInRaster * src1PixelStride;

				src2Pixels = src2Iter.Raster.Buffer;
				src2RowStride = src2Iter.Raster.RowStride;
				src2PixelStride = src2Iter.Raster.PixelStride;
				src2Offset = src2Iter.OffsetYInRaster * src2RowStride + 
					src2Iter.OffsetXInRaster * src2PixelStride;

				destPixels = destIter.Raster.Buffer;
				destRowStride = destIter.Raster.RowStride;
				destPixelStride = destIter.Raster.PixelStride;
				destOffset = destIter.OffsetYInRaster * destRowStride + 
					destIter.OffsetXInRaster * destPixelStride;
				this.width = width;
			}
			
			public void NextX() {
				destOffset += destPixelStride;
				src1Offset += src1PixelStride;
				src2Offset += src2PixelStride;
			}
			
			public void NextY() {
				destOffset += destRowStride - (width * destPixelStride);
				src1Offset += src1RowStride - (width * src1PixelStride);
				src2Offset += src2RowStride - (width * src2PixelStride);
			}
				
		}

	}
}
