/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbTaxonomyGroupDAO {

    // singleton쐬
    private static XbTaxonomyGroupDAO instance = new XbTaxonomyGroupDAO();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbTaxonomyGroupDAO() {
    }

    // CX^X擾
    public static synchronized XbTaxonomyGroupDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected void insert(XbTaxonomyGroupObj obj) throws XbException {
        final String query = "insert into xb_taxonomy_group values (?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;

        try {
            // SQLݒ
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getTaxonomyGroupId());
            stmt.setString(index++, obj.getTaxonomyGroupName());
            stmt.setString(index++, obj.getSpecificationNo());
            stmt.setString(index++, obj.getNote());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreationDate().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}