/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbResourceItemAttrDAO {

    // singleton쐬
    private static XbResourceItemAttrDAO instance = new XbResourceItemAttrDAO();
    // Connectionϐ
    private Connection conn = null;

    // Xe[gg쐬

    // RXgN^
    private XbResourceItemAttrDAO() {
    }

    // CX^X擾
    public static XbResourceItemAttrDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected int insert(XbResourceItemAttrObj obj) throws XbException {
        final String query = "insert into xb_resource_item_attr values (?, ?, ?, ?)";
        PreparedStatement stmt = null;

        try {
            // SQLݒ
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getResource_item_attr_id());
            stmt.setLong(index++, obj.getResource_item_id());
            stmt.setString(index++, obj.getAttribute_name());
            stmt.setString(index++, obj.getAttribute_value());

            // SQL@s
            int count = stmt.executeUpdate();

            return count;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}