/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbLinkbaseRefDAO {

    // singleton쐬
    private static XbLinkbaseRefDAO instance = new XbLinkbaseRefDAO();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbLinkbaseRefDAO() {
    }

    // CX^X擾
    public static XbLinkbaseRefDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected void insert(XbLinkbaserefObj obj) throws XbException {
        final String query = "insert into xb_linkbaseref values (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;

        try {
            // SQLݒ
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getLinkbaserefId());
            stmt.setString(index++, obj.getLinkbaseRole());
            stmt.setString(index++, obj.getLinkbaseHref());
            stmt.setLong(index++, obj.getTaxonomyId());
            stmt.setLong(index++, obj.getTaxonomyGroupId());
            stmt.setString(index++, obj.getCategory());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreationDate().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    protected long select(long strTaxonomyId, String strCategry) throws XbException {
        final String query = "select linkbaseref_id, linkbase_role, linkbase_href, taxonomy_id, taxonomy_group_id, category, creation_date from xb_linkbaseref where taxonomy_id = ? and category like ?";
        PreparedStatement stmt = null;

        try {
            // CXg
            stmt = conn.prepareStatement(query);
            int index = 1;

            stmt.setLong(index++, strTaxonomyId);
            stmt.setString(index++, strCategry + "%");

            ResultSet rs = stmt.executeQuery();

            long reLinkId = 0;
            if (rs.next()) {
                reLinkId = rs.getLong("linkbaseref_id");
            }

            // ʃZbgN[Y
            rs.close();

            return reLinkId;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}