/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbItemLabel20DAO extends XbItemLabelDAO {

    // singleton쐬
    private static XbItemLabelDAO instance = null;

    // RXgN^
    private XbItemLabel20DAO() {
    }

    // CX^X擾
    public static synchronized XbItemLabelDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (instance == null) {
            conn = connection;
            instance = new XbItemLabel20DAO();
        }

        return instance;
    }

    protected ArrayList<XbItemLabelObj> getItemLabel(long grpId) throws XbException {
        try {
            // Xe[gg쐬
            PreparedStatement stmt;
            StringBuffer strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("itm.taxonomy_group_id as taxonomy_group_id, ");
            strb_sql.append("itm.taxonomy_id as taxonomy_id, ");
            strb_sql.append("itm.taxonomy_item_id as taxonomy_item_id, ");
            strb_sql.append("res.label_lang as label_lang, ");
            strb_sql.append("res.resource_value as resource_value ");
            strb_sql.append("from ");
            strb_sql.append("xb_linkbaseref ref, ");
            strb_sql.append("xb_taxonomy_item itm, ");
            strb_sql.append("xb_linkbase_locator loc, ");
            strb_sql.append("xb_linkbase_arc arc, ");
            strb_sql.append("xb_linkbase_resource res ");
            strb_sql.append("where ref.linkbaseref_id = loc.linkbaseref_id ");
            strb_sql.append("and loc.linkbaseref_id = arc.linkbaseref_id ");
            strb_sql.append("and arc.linkbaseref_id = res.linkbaseref_id ");
            strb_sql.append("and ref.linkbase_role  = 'http://www.xbrl.org/linkprops/linkRef/label' ");
            strb_sql.append("and arc.arc_arcrole    = 'http://www.xbrl.org/linkprops/arc/element-label' ");
            strb_sql.append("and res.label_role     = 'http://www.xbrl.org/linkprops/label/standard' ");
            strb_sql.append("and itm.taxonomy_group_id = ? ");
            strb_sql.append("and ref.taxonomy_group_id = itm.taxonomy_group_id ");
            strb_sql.append("and itm.item_id = loc.loc_identifier ");
            strb_sql.append("and loc.loc_label = arc.arc_from ");
            strb_sql.append("and res.resource_label = arc.arc_to");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setLong(index++, grpId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbItemLabelObj> relist = new ArrayList<XbItemLabelObj>();
            while (rs.next()) {
                // TuXg
                XbItemLabelObj Obj = new XbItemLabelObj();
                Obj.setTaxonomyGroupId(rs.getLong("taxonomy_group_id"));
                Obj.setTaxonomyId(rs.getLong("taxonomy_id"));
                Obj.setTaxonomyItemId(rs.getLong("taxonomy_item_id"));
                Obj.setLang(rs.getString("label_lang"));
                Obj.setValue(rs.getString("resource_value"));
                relist.add(Obj);
            }
            // ʃZbgN[Y
            rs.close();
            // Xe[ggN[Y
            stmt.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}