/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbRefObj;

/**
 * @author Masako Okayasu
 */
public class XbRefDao {

    // singleton쐬
    private static XbRefDao instance = new XbRefDao();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbRefDao() {
    }

    // CX^X擾
    public static synchronized XbRefDao getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    public void insert(XbRefObj obj) throws XbException {
        final String query = "insert into xb_ref values (?,?,?,?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setInt(index++, obj.getRef_type());
            stmt.setLong(index++, obj.getRef_id());
            stmt.setString(index++, obj.getRef_name());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbRefObj> selectAll() throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("ref_type, ");
            strb_sql.append("ref_id, ");
            strb_sql.append("ref_name, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_ref ");
            strb_sql.append("order by ref_type, ref_id ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbRefObj> relist = new ArrayList<XbRefObj>();
            while (rs.next()) {
                XbRefObj obj = new XbRefObj();
                obj.setRef_type(rs.getInt("ref_type"));
                obj.setRef_id(rs.getLong("ref_id"));
                obj.setRef_name(rs.getString("ref_name"));
                obj.setCreation_date(rs.getDate("creation_date"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbRefObj> selectAllByType(int ref_type) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("ref_type, ");
            strb_sql.append("ref_id, ");
            strb_sql.append("ref_name, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_ref ");
            strb_sql.append("where ref_type=? ");
            strb_sql.append("order by ref_id ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setInt(index++, ref_type);

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbRefObj> relist = new ArrayList<XbRefObj>();
            while (rs.next()) {
                XbRefObj obj = new XbRefObj();
                obj.setRef_type(rs.getInt("ref_type"));
                obj.setRef_id(rs.getLong("ref_id"));
                obj.setRef_name(rs.getString("ref_name"));
                obj.setCreation_date(rs.getDate("creation_date"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public XbRefObj select(int ref_type, long ref_id) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("ref_type, ");
            strb_sql.append("ref_id, ");
            strb_sql.append("ref_name, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_ref ");
            strb_sql.append("where ref_type=? and ref_id=? ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setInt(index++, ref_type);
            stmt.setLong(index++, ref_id);

            ResultSet rs = stmt.executeQuery();
            XbRefObj obj = null;
            while (rs.next()) {
                obj = new XbRefObj();
                obj.setRef_type(rs.getInt("ref_type"));
                obj.setRef_id(rs.getLong("ref_id"));
                obj.setRef_name(rs.getString("ref_name"));
                obj.setCreation_date(rs.getDate("creation_date"));
            }

            // ʃZbgN[Y
            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public long getNextId(int ref_type) throws XbException {
        final String query = "select max(ref_id)+1 as max from xb_ref where ref_type=? ";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setInt(index++, ref_type);

            ResultSet rs = stmt.executeQuery();
            rs.next();

            return (rs.getLong("max") == 0 ? 1 : rs.getLong("max"));
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}