/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbMeasureObj;

/**
 * @author Masako Okayasu
 */
public class XbMeasureDao {

    // singleton쐬
    private static XbMeasureDao instance = new XbMeasureDao();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbMeasureDao() {
    }

    // CX^X擾
    public static synchronized XbMeasureDao getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    public void insert(XbMeasureObj obj) throws XbException {
        final String query = "insert into xb_measure values (?,?,?,?,?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getMeasure_id());
            stmt.setString(index++, obj.getMeasure_name());
            stmt.setShort(index++, obj.getMoney_flag());
            stmt.setString(index++, obj.getValue());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbMeasureObj> selectAll() throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("measure_id, ");
            strb_sql.append("measure_name, ");
            strb_sql.append("money_flag, ");
            strb_sql.append("value, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_measure ");
            strb_sql.append("order by measure_id ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbMeasureObj> relist = new ArrayList<XbMeasureObj>();
            while (rs.next()) {
                XbMeasureObj obj = new XbMeasureObj();
                obj.setMeasure_id(rs.getLong("measure_id"));
                obj.setMeasure_name(rs.getString("measure_name"));
                obj.setMoney_flag(rs.getShort("money_flag"));
                obj.setValue(rs.getString("value"));
                obj.setCreation_date(rs.getDate("creation_date"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public XbMeasureObj select(long measure_id) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("measure_id, ");
            strb_sql.append("measure_name, ");
            strb_sql.append("money_flag, ");
            strb_sql.append("value, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_measure ");
            strb_sql.append("where measure_id=? ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, measure_id);

            ResultSet rs = stmt.executeQuery();
            XbMeasureObj obj = null;
            while (rs.next()) {
                obj = new XbMeasureObj();
                obj.setMeasure_id(rs.getLong("measure_id"));
                obj.setMeasure_name(rs.getString("measure_name"));
                obj.setMoney_flag(rs.getShort("money_flag"));
                obj.setValue(rs.getString("value"));
                obj.setCreation_date(rs.getDate("creation_date"));
            }

            // ʃZbgN[Y
            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public long getNextId() throws XbException {
        final String query = "select max(measure_id)+1 as max from xb_measure ";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            ResultSet rs = stmt.executeQuery();
            rs.next();

            return (rs.getLong("max") == 0 ? 1 : rs.getLong("max"));
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}