/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbIdentifierObj;

/**
 * @author Masako Okayasu
 */
public class XbIdentifierDao {

    // singleton쐬
    private static XbIdentifierDao instance = new XbIdentifierDao();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    public XbIdentifierDao() {
    }

    // CX^X擾
    public static synchronized XbIdentifierDao getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    public void insert(XbIdentifierObj obj) throws XbException {
        final String query = "insert into xb_identifier values (?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getIdentifier_id());
            stmt.setString(index++, obj.getIdentifier_name());
            stmt.setString(index++, obj.getSchema());
            stmt.setString(index++, obj.getValue());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbIdentifierObj> selectAll() throws XbException {
        final String query = "select identifier_id, identifier_name, schema, value, creation_date from xb_identifier order by identifier_id";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbIdentifierObj> relist = new ArrayList<XbIdentifierObj>();
            while (rs.next()) {
                XbIdentifierObj obj = new XbIdentifierObj();
                obj.setIdentifier_id(rs.getLong("identifier_id"));
                obj.setIdentifier_name(rs.getString("identifier_name"));
                obj.setSchema(rs.getString("schema"));
                obj.setValue(rs.getString("value"));
                obj.setCreation_date(rs.getDate("creation_date"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public XbIdentifierObj select(long identifier_id) throws XbException {
        final String query = "select identifier_id, identifier_name, schema, value, creation_date from xb_identifier where identifier_id = ?";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);
            stmt.setLong(1, identifier_id);

            ResultSet rs = stmt.executeQuery();
            XbIdentifierObj obj = null;
            while (rs.next()) {
                obj = new XbIdentifierObj();
                obj.setIdentifier_id(rs.getLong("identifier_id"));
                obj.setIdentifier_name(rs.getString("identifier_name"));
                obj.setSchema(rs.getString("schema"));
                obj.setValue(rs.getString("value"));
                obj.setCreation_date(rs.getDate("creation_date"));
            }

            // ʃZbgN[Y
            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public long getNextId() throws XbException {
        final String query = "select max(identifier_id)+1 as max from xb_identifier";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            ResultSet rs = stmt.executeQuery();
            rs.next();

            return (rs.getLong("max") == 0 ? 1 : rs.getLong("max"));
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}