/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbConstants;
import jp.co.going.xbrl.common.XbException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
class XbUnit21 extends XbUnit {

    private ArrayList<Long> unitIdList;

    protected XbUnit21(Connection conn, Document doc) {
        super(conn, doc);
        unitIdList = new ArrayList<Long>();
    }

    /**
     * Unit2.1쐬
     * 
     * @param contextId
     *            contextId
     * @return unitTag
     * @throws XbException
     */
    protected Element createContextUnit(XbContextUnitObj unitObj, Element rootInstance) throws XbException {
        Element unit = null;

        if (!unitIdList.contains(unitObj.getUnitId())) {
            unitIdList.add(unitObj.getUnitId());

            // measure擾
            ArrayList<XbUnitMeasureObj> measureList = XbUnitMeasureDAO.getInstance(super.conn).getMeasure(unitObj.getUnitId());
            // unitTag
            unit = super.createElement(this.doc, XbConstants.TAG_UNIT);
            // ǉ
            super.setAttribute(unit, XbConstants.ATTRIBUTE_ID, unitObj.getName());

            // measure
            if (measureList.size() != 0) { // measure
                for (int i = 0; i < measureList.size(); i++) {
                    XbUnitMeasureObj obj = measureList.get(i);
                    // measureTag
                    Element measure = super.createElement(super.doc, XbConstants.TAG_MEASURE);
                    // node쐬
                    super.createMeasureTag(measure, obj.isMoneyFlag(), obj.getValue(), rootInstance, XbConstants.ISO4217_URI21);
                    // unitɐݒ
                    super.appendChild(unit, measure);
                }
            } else { // divide
                // divide擾
                ArrayList<XbUnitDivideObj> divideList = XbUnitDivideDAO.getInstance(super.conn).getDivide(unitObj.getUnitId());
                // divideTag
                Element divide = super.createElement(super.doc, XbConstants.TAG_DIVIDE);

                for (int i = 0; i < divideList.size(); i++) {
                    XbUnitDivideObj obj = divideList.get(i);
                    // numerator/denominatorTag
                    Element numdenorator = null;
                    if (XbConstants.ONE_VALUE.equals(obj.getDivideType())) { // numerator
                        numdenorator = super.createElement(super.doc, XbConstants.TAG_NUMERATOR);
                    } else if (XbConstants.TWO_VALUE.equals(obj.getDivideType())) { // denominator
                        numdenorator = super.createElement(super.doc, XbConstants.TAG_DENOMINATOR);
                    }
                    // measureTag
                    Element measure = super.createElement(super.doc, XbConstants.TAG_MEASURE);
                    // node쐬
                    super.createMeasureTag(measure, obj.isMoneyFlag(), obj.getValue(), rootInstance, XbConstants.ISO4217_URI21);
                    // numerator/denominatorɐݒ
                    super.appendChild(numdenorator, measure);
                    // divideɐݒ
                    super.appendChild(divide, numdenorator);
                    // unitɐݒ
                    super.appendChild(unit, divide);
                }
            }
        }
        return unit;
    }
}