/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import jp.co.going.xbrl.common.XbConstants;
import jp.co.going.xbrl.common.XbException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
class XbPeriod extends XbContext {

    private Document doc;

    protected XbPeriod(Document doc) throws XbException {
        this.doc = doc;
    }

    /**
     * Period쐬
     * 
     * @param sDate
     * @param eDate
     * @return
     * @throws XbException
     */
    protected Element createPeriod(String sDate, String eDate) throws XbException {
        // periodTag
        Element period = super.createElement(this.doc, XbConstants.TAG_PERIOD);
        // Ԕ
        if ((sDate == null || "".equals(sDate)) && (eDate == null || "".equals(eDate))) { // forever
            Element forever = super.createElement(this.doc, XbConstants.TAG_FOREVER);
            // periodɐݒ
            super.appendChild(period, forever);
        } else if (sDate.equals(eDate)) { // instant
            Element instant = super.createElement(this.doc, XbConstants.TAG_INSTANT);
            super.appendChild(instant, this.doc, sDate);
            // periodɐݒ
            super.appendChild(period, instant);
        } else {
            Element start = super.createElement(this.doc, XbConstants.TAG_STARTDATE);
            Element end = super.createElement(this.doc, XbConstants.TAG_ENDDATE);
            super.appendChild(start, this.doc, sDate);
            super.appendChild(end, this.doc, eDate);
            // periodɐݒ
            super.appendChild(period, start);
            super.appendChild(period, end);
        }

        return period;
    }
}