/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbItemSearchInfoDAO {

    // singleton쐬
    private static final XbItemSearchInfoDAO instance = new XbItemSearchInfoDAO();
    private Connection conn = null;

    // RXgN^
    private XbItemSearchInfoDAO() {
    }

    // CX^X擾
    protected static synchronized XbItemSearchInfoDAO getInstance(Connection connection) {
        // CX^X𐶐
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected String getEntityName(long entityId) throws XbException {
        final String query = "select entity_name from xb_entity where entity_id = ?";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);
            stmt.setLong(1, entityId);

            ResultSet rs = stmt.executeQuery();

            String entity = "";
            if (rs.next()) {
                // TuXg
                entity = rs.getString("entity_name");
            }
            // ʃZbgN[Y
            rs.close();

            return entity;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    protected XbItemSearchUnitObj getUnitName(long contextId) throws XbException {
        final String query = "select u.unit_name as unit_name , u.name as name from xb_context_unit cu , xb_unit u where cu.context_id = ? and cu.unit_id = u.unit_id ";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);
            stmt.setLong(1, contextId);

            ResultSet rs = stmt.executeQuery();

            XbItemSearchUnitObj obj = new XbItemSearchUnitObj();
            if (rs.next()) {
                // TuXg
                obj.setUnitName(rs.getString("unit_name"));
                obj.setName(rs.getString("name"));
            }
            // ʃZbgN[Y
            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}