/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;

import jp.co.going.xbrl.common.XbConstants;
import jp.co.going.xbrl.common.XbException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
class XbContext20 extends XbContext {

    private Document doc;
    private XbEntity entity;
    private XbPeriod period;
    private XbUnit unit;
    private XbScenario scenario;

    protected XbContext20(Connection conn, Document doc) throws XbException {
        this.doc = doc;

        entity = new XbEntity(conn, doc);
        period = new XbPeriod(doc);
        unit = new XbUnit20(conn, doc);
        scenario = new XbScenario(conn, doc);
    }

    /**
     * ReLXg^O쐬
     * 
     * @param obj
     *            ReLXg
     * @param rootElement
     *            root^O
     * @throws XbException
     */
    protected Element createContext(XbContextObj obj, Element rootElement) throws XbException {

        Element context = null;
        // context^O쐬(nonNumeric/numeric)
        if (XbConstants.ATTRIBUTE_NO_NUMERIC.equals(obj.getContextType())) {
            context = super.createElement(this.doc, XbConstants.TAG_NONNUMERICCONTEXT);
        } else {
            context = super.createElement(this.doc, XbConstants.TAG_NUMERICCONTEXT);
            // precisionǉ
            super.setAttribute(context, XbConstants.ATTRIBUTE_PRECISION, String.valueOf(obj.getPrecision()));
            // cwaǉ
            if (XbConstants.ONE_VALUE.equals(obj.getCwa())) {
                super.setAttribute(context, XbConstants.ATTRIBUTE_CWA, XbConstants.ATTRIBUTE_VALUE_TRUE);
            } else {
                super.setAttribute(context, XbConstants.ATTRIBUTE_CWA, XbConstants.ATTRIBUTE_VALUE_FALSE);
            }
        }
        // idǉ
        super.setAttribute(context, XbConstants.ATTRIBUTE_ID, obj.getName());

        // entity^O쐬
        Element entityTag = entity.createEntity(obj.getEntityId(), rootElement);
        // period^O쐬
        Element periodTag = period.createPeriod(obj.getPeriodStartDate(), obj.getPeriodEndDate());
        // unit^O쐬
        Element unitTag = unit.createUnit(obj.getContextId(), rootElement);
        // scenario^O쐬
        Element scenarioTag = scenario.createScenario(obj.getContextId(), rootElement);

        // context^Oɒǉ
        super.appendChild(context, entityTag); // entity
        super.appendChild(context, periodTag); // period
        // unit_flag
        if (XbConstants.ATTRIBUTE_NUMERIC.equals(obj.getContextType()) || (XbConstants.ATTRIBUTE_NO_NUMERIC.equals(obj.getContextType()) && obj.isUnitFlag())) {
            super.appendChild(context, unitTag); // unit
        }

        super.appendChild(context, scenarioTag); // scenario

        return context;
    }
}