/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * waqkŎgp^caɓo^NX
 * 
 * @author Going Dot Com Inc.
 */
class XbItemTypeDAO {

    // singleton쐬
    private static final XbItemTypeDAO instance = new XbItemTypeDAO();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbItemTypeDAO() {
    }

    // CX^X擾
    protected static synchronized XbItemTypeDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected int select(String strTypeName, String strVerSion) throws XbException {
        PreparedStatement stmt = null;

        try {
            StringBuffer strb_sql = new StringBuffer();

            // CXg
            int relist = 0;
            strb_sql.append("select ");
            strb_sql.append("type_name, ");
            strb_sql.append("attribute_name, ");
            strb_sql.append("specification_no, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_item_type ");
            strb_sql.append("where type_name = ? ");
            strb_sql.append("and specification_no = ?");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;
            stmt.setString(index++, strTypeName);
            stmt.setString(index++, strVerSion);

            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                relist++;
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    protected void insert(XbItemTypeObj obj) throws XbException {
        final String query = "insert into xb_item_type values (?, ?, ?, ?)";
        PreparedStatement stmt = null;

        try {
            // SQLݒ
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setString(index++, obj.getType_name());
            stmt.setString(index++, obj.getAttribute_name());
            stmt.setString(index++, obj.getSpecification_no());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}