/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * {XL[}caɓo^NX
 * 
 * @author Going Dot Com Inc.
 */
class XbBaseSchemaDAO {

    // singleton쐬
    private static final XbBaseSchemaDAO instance = new XbBaseSchemaDAO();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbBaseSchemaDAO() {
    }

    // CX^X擾
    protected static synchronized XbBaseSchemaDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected int select(String strNodeName, String strVerSion) throws XbException {
        final String query = "select namespace, namespace_url, specification_no, creation_date from xb_base_schema where namespace = ? and specification_no = ?";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);
            int index = 1;
            stmt.setString(index++, strNodeName);
            stmt.setString(index++, strVerSion);

            ResultSet rs = stmt.executeQuery();
            int relist = 0;
            while (rs.next()) {
                relist++;
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    protected void insert(XbBaseSchemaObj obj) throws XbException {
        final String query = "insert into xb_base_schema values (?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            // SQLݒ
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setString(index++, obj.getNamespace());
            stmt.setString(index++, obj.getNamespace_url());
            stmt.setString(index++, obj.getSpecification_no());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}