/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbTaxonomyItemDAO {

    // singleton쐬
    private static XbTaxonomyItemDAO instance = new XbTaxonomyItemDAO();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbTaxonomyItemDAO() {
    }

    // CX^X擾
    public static XbTaxonomyItemDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected int insert(XbTaxonomyItemObj obj) throws XbException {
        final String query = "insert into xb_taxonomy_item values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;

        try {
            // SQLݒ
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getTaxonomyItemId());
            stmt.setLong(index++, obj.getTaxonomyId());
            stmt.setLong(index++, obj.getTaxonomyGroupId());
            stmt.setString(index++, obj.getItemId());
            stmt.setString(index++, obj.getItemName());
            stmt.setString(index++, obj.getItemType());
            stmt.setString(index++, obj.getItemSubstitutiongroup());
            stmt.setString(index++, obj.getItemBalance());
            stmt.setInt(index++, obj.getItemNillable());
            stmt.setString(index++, obj.getItemPeriodType());
            stmt.setInt(index++, obj.getAbstractFlg());
            stmt.setString(index++, obj.getDocumentation());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreationDate().getTime()));

            // SQL@s
            int count = stmt.executeUpdate();

            return count;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}