/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbTaxonomyDAO {

    // singleton쐬
    private static XbTaxonomyDAO instance = new XbTaxonomyDAO();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbTaxonomyDAO() {
    }

    // CX^X擾
    public static XbTaxonomyDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected void insert(XbTaxonomyObj obj) throws XbException {
        final String query = "insert into xb_taxonomy values (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;

        try {
            // SQLݒ
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getTaxonomyId());
            stmt.setLong(index++, obj.getTaxonomyGroupId());
            stmt.setString(index++, obj.getTaxonomyName());
            stmt.setString(index++, obj.getTaxonomyFile());
            stmt.setString(index++, obj.getNamespace());
            stmt.setString(index++, obj.getNamespaceUrl());
            stmt.setShort(index++, obj.isTerminatedFlag() ? (short) 1 : 0);
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreationDate().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}