/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbTaxItemNextIdDAO implements XbNextIdDAO {

    // singleton
    private static XbNextIdDAO nextId = null;
    // őli[ϐ
    private long nextValue = 0;

    // RXgN^
    private XbTaxItemNextIdDAO(Connection conn) throws XbException {
        PreparedStatement stmt = null;
        try {
            // TAXONOMY_GROUP_ID̍ől擾
            stmt = conn.prepareStatement("select max(taxonomy_item_id) as id from xb_taxonomy_item");

            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                nextValue = rs.getLong("id");
            }

            // ʃZbgN[Y
            rs.close();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    /**
     * CX^X𐶐
     * 
     * @param conn
     *            RlNV
     * @return TaxItemNextIdDAOCX^X
     * @throws XbException
     */
    public static synchronized XbNextIdDAO getInstance(Connection conn) throws XbException {
        // CX^X𐶐
        if (nextId == null) {
            nextId = new XbTaxItemNextIdDAO(conn);
        }

        return nextId;
    }

    /**
     * taxonomy_item_id̃V[PXԍ擾
     * 
     * @return taxonomy_item_id̍ől
     */
    public synchronized long getNextValue() {
        return ++nextValue;
    }
}