/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbResourceItemDAO {

    // singleton쐬
    private static XbResourceItemDAO instance = new XbResourceItemDAO();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbResourceItemDAO() {
    }

    // CX^X擾
    public static XbResourceItemDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected int insert(XbResourceItemObj obj) throws XbException {
        final String query = "insert into xb_resource_item values (?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;

        try {
            // SQLݒ
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getResource_item_id());
            stmt.setLong(index++, obj.getResource_id());
            stmt.setString(index++, obj.getNamespace());
            stmt.setString(index++, obj.getNamespace_url());
            stmt.setString(index++, obj.getItem_name());
            stmt.setString(index++, obj.getItem_value());

            // SQL@s
            int count = stmt.executeUpdate();

            return count;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}
