/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public abstract class XbItemLabelDAO {

    // Connectionϐ
    protected static Connection conn = null;

    private void insert(ArrayList<XbItemLabelObj> obj) throws XbException {
        final String query = "INSERT INTO xb_item_label (taxonomy_group_id, taxonomy_id, taxonomy_item_id, label_lang, resource_value) VALUES (?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            // Xe[gg쐬
            stmt = conn.prepareStatement(query);
            for (int i = 0; i < obj.size(); i++) {
                XbItemLabelObj label = obj.get(i);

                // SQLݒ
                int index = 1;
                stmt.setLong(index++, label.getTaxonomyGroupId());
                stmt.setLong(index++, label.getTaxonomyId());
                stmt.setLong(index++, label.getTaxonomyItemId());
                stmt.setString(index++, label.getLang());
                stmt.setString(index++, label.getValue());

                // SQL@s
                stmt.executeUpdate();
            }
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    // Xe[ggN[Y
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    protected final void setItemLabel(long grpId) throws XbException {
        // \擾
        ArrayList<XbItemLabelObj> labelList = getItemLabel(grpId);
        // \o^
        this.insert(labelList);
    }

    abstract protected ArrayList<XbItemLabelObj> getItemLabel(long grpId) throws XbException;
}